/*
 * Decompiled with CFR 0.152.
 */
package dev.ajaretro.foliaCore.commands;

import dev.ajaretro.foliaCore.FoliaCore;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SpawnCommand
implements CommandExecutor {
    private final FoliaCore plugin;

    public SpawnCommand(FoliaCore plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            this.plugin.getMessenger().sendError(sender, "This command can only be run by a player.");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("foliacore.spawn")) {
            this.plugin.getMessenger().sendError((CommandSender)player, "You do not have permission to use this command.");
            return true;
        }
        Location spawn = this.plugin.getTeleportManager().getSpawn();
        if (spawn.getWorld() == null) {
            this.plugin.getMessenger().sendError((CommandSender)player, "The spawn world is not loaded! Please contact an admin.");
            return true;
        }
        this.plugin.getTeleportManager().startTeleport(player, spawn, "Teleported to spawn.");
        return true;
    }
}

