/*
 * Decompiled with CFR 0.152.
 */
package dev.ajaretro.foliaCore.commands;

import dev.ajaretro.foliaCore.FoliaCore;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SetWarpCommand
implements CommandExecutor {
    private final FoliaCore plugin;
    private static final Pattern WARP_NAME_PATTERN = Pattern.compile("^[a-zA-Z0-9_]{3,20}$");

    public SetWarpCommand(FoliaCore plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            this.plugin.getMessenger().sendError(sender, "This command can only be run by a player.");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("foliacore.setwarp")) {
            this.plugin.getMessenger().sendError((CommandSender)player, "You do not have permission to use this command.");
            return true;
        }
        if (args.length == 0) {
            this.plugin.getMessenger().sendError((CommandSender)player, "Usage: /setwarp <name>");
            return true;
        }
        String warpName = args[0];
        if (!WARP_NAME_PATTERN.matcher(warpName).matches()) {
            this.plugin.getMessenger().sendError((CommandSender)player, "Warp name must be 3-20 characters (letters, numbers, underscore).");
            return true;
        }
        if (this.plugin.getWarpManager().isWarp(warpName)) {
            this.plugin.getMessenger().sendError((CommandSender)player, "A warp with that name already exists. Use /delwarp first.");
            return true;
        }
        this.plugin.getWarpManager().createWarp(warpName, player.getLocation());
        this.plugin.getMessenger().sendSuccess((CommandSender)player, "Warp '" + String.valueOf(ChatColor.GOLD) + warpName + String.valueOf(ChatColor.GREEN) + "' has been set!");
        return true;
    }
}

