/*
 * Decompiled with CFR 0.152.
 */
package dev.ajaretro.foliaCore.commands;

import dev.ajaretro.foliaCore.FoliaCore;
import dev.ajaretro.foliaCore.managers.TeleportManager;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SetHomeCommand
implements CommandExecutor {
    private final FoliaCore plugin;
    private final TeleportManager tm;
    private static final Pattern HOME_NAME_PATTERN = Pattern.compile("^[a-zA-Z0-9_]{3,20}$");

    public SetHomeCommand(FoliaCore plugin) {
        this.plugin = plugin;
        this.tm = plugin.getTeleportManager();
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String homeName;
        if (!(sender instanceof Player)) {
            this.plugin.getMessenger().sendError(sender, "This command can only be run by a player.");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("foliacore.sethome")) {
            this.plugin.getMessenger().sendError((CommandSender)player, "You do not have permission to set a home.");
            return true;
        }
        int maxHomes = this.tm.getMaxHomes(player);
        if (args.length == 0) {
            if (maxHomes != 1) {
                this.plugin.getMessenger().sendError((CommandSender)player, "You have access to multiple homes. Please specify a name: /sethome <name>");
                return true;
            }
            homeName = "home";
        } else {
            homeName = args[0];
        }
        if (!HOME_NAME_PATTERN.matcher(homeName).matches()) {
            this.plugin.getMessenger().sendError((CommandSender)player, "Home name must be 3-20 characters and only contain letters, numbers, and underscores.");
            return true;
        }
        boolean isOverwrite = this.tm.getHome(player.getUniqueId(), homeName) != null;
        int currentHomes = this.tm.getHomeCount(player.getUniqueId());
        if (!isOverwrite && currentHomes >= maxHomes) {
            this.plugin.getMessenger().sendError((CommandSender)player, "You have reached your maximum home limit of " + maxHomes + ".");
            return true;
        }
        this.tm.setHome(player.getUniqueId(), homeName, player.getLocation());
        if (isOverwrite) {
            this.plugin.getMessenger().sendSuccess((CommandSender)player, "Home '" + String.valueOf(ChatColor.GOLD) + homeName + String.valueOf(ChatColor.GREEN) + "' has been updated.");
            return true;
        }
        this.plugin.getMessenger().sendSuccess((CommandSender)player, "Home '" + String.valueOf(ChatColor.GOLD) + homeName + String.valueOf(ChatColor.GREEN) + "' set! (" + (currentHomes + 1) + "/" + String.valueOf(maxHomes == Integer.MAX_VALUE ? "Unlimited" : Integer.valueOf(maxHomes)) + ")");
        return true;
    }
}

