/*
 * Decompiled with CFR 0.152.
 */
package dev.ajaretro.foliaCore.commands;

import dev.ajaretro.foliaCore.FoliaCore;
import dev.ajaretro.foliaCore.data.Mail;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class MailCommand
implements CommandExecutor {
    private final FoliaCore plugin;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yy HH:mm");

    public MailCommand(FoliaCore plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (!(sender instanceof Player)) {
            this.plugin.getMessenger().sendError(sender, "This command can only be run by a player.");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            this.sendHelp(player);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "send": {
                this.handleSend(player, args);
                break;
            }
            case "read": {
                this.handleRead(player);
                break;
            }
            case "clear": {
                this.handleClear(player);
                break;
            }
            default: {
                this.sendHelp(player);
            }
        }
        return true;
    }

    private void sendHelp(Player player) {
        this.plugin.getMessenger().sendMessage((CommandSender)player, String.valueOf(ChatColor.YELLOW) + "--- FoliaCore Mail Help ---");
        this.plugin.getMessenger().sendMessage((CommandSender)player, String.valueOf(ChatColor.GOLD) + "/mail send <player> <message...>" + String.valueOf(ChatColor.WHITE) + " - Send offline mail");
        this.plugin.getMessenger().sendMessage((CommandSender)player, String.valueOf(ChatColor.GOLD) + "/mail read" + String.valueOf(ChatColor.WHITE) + " - Read your mail");
        this.plugin.getMessenger().sendMessage((CommandSender)player, String.valueOf(ChatColor.GOLD) + "/mail clear" + String.valueOf(ChatColor.WHITE) + " - Clear your mailbox");
    }

    private void handleSend(Player player, String[] args) {
        Player onlineTarget;
        if (!player.hasPermission("foliacore.mail.send")) {
            this.plugin.getMessenger().sendError((CommandSender)player, "You do not have permission to send mail.");
            return;
        }
        if (args.length < 3) {
            this.plugin.getMessenger().sendError((CommandSender)player, "Usage: /mail send <player> <message...>");
            return;
        }
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[1]);
        if (target == null || !target.hasPlayedBefore()) {
            this.plugin.getMessenger().sendError((CommandSender)player, "Player not found.");
            return;
        }
        if (this.plugin.getChatManager().isBlocked(player.getUniqueId(), target.getUniqueId())) {
            this.plugin.getMessenger().sendError((CommandSender)player, "You cannot send mail to this player as they have you blocked.");
            return;
        }
        if (this.plugin.getChatManager().isBlocked(target.getUniqueId(), player.getUniqueId())) {
            this.plugin.getMessenger().sendError((CommandSender)player, "You have this player blocked. Use /unblock to send them mail.");
            return;
        }
        StringBuilder messageBuilder = new StringBuilder();
        for (int i = 2; i < args.length; ++i) {
            messageBuilder.append(args[i]).append(" ");
        }
        String message = messageBuilder.toString().trim();
        this.plugin.getChatManager().sendMail(player.getUniqueId(), target.getUniqueId(), message);
        this.plugin.getMessenger().sendSuccess((CommandSender)player, "Mail sent to " + target.getName() + ".");
        if (target.isOnline() && (onlineTarget = target.getPlayer()) != null) {
            onlineTarget.getScheduler().run((Plugin)this.plugin, task -> this.plugin.getMessenger().sendMessage((CommandSender)onlineTarget, String.valueOf(ChatColor.GREEN) + "You have received new mail from " + player.getName() + "! Type /mail read"), null);
        }
    }

    private void handleRead(Player player) {
        if (!player.hasPermission("foliacore.mail.read")) {
            this.plugin.getMessenger().sendError((CommandSender)player, "You do not have permission to read mail.");
            return;
        }
        List<Mail> mailbox = this.plugin.getChatManager().getMail(player.getUniqueId());
        if (mailbox == null || mailbox.isEmpty()) {
            this.plugin.getMessenger().sendMessage((CommandSender)player, "Your mailbox is empty.");
            return;
        }
        this.plugin.getMessenger().sendMessage((CommandSender)player, String.valueOf(ChatColor.YELLOW) + "--- Your Mailbox ---");
        for (int i = 0; i < mailbox.size(); ++i) {
            Mail mail = mailbox.get(i);
            OfflinePlayer sender = Bukkit.getOfflinePlayer((UUID)mail.sender());
            String senderName = sender.getName() != null ? sender.getName() : "Unknown";
            String date = this.dateFormat.format(new Date(mail.timestamp()));
            player.sendMessage(String.valueOf(ChatColor.GOLD) + "Mail #" + (i + 1) + " From: " + String.valueOf(ChatColor.WHITE) + senderName + String.valueOf(ChatColor.GRAY) + " (" + date + ")");
            player.sendMessage(String.valueOf(ChatColor.GRAY) + "  > " + String.valueOf(ChatColor.WHITE) + mail.message());
        }
    }

    private void handleClear(Player player) {
        if (!player.hasPermission("foliacore.mail.clear")) {
            this.plugin.getMessenger().sendError((CommandSender)player, "You do not have permission to clear mail.");
            return;
        }
        List<Mail> mailbox = this.plugin.getChatManager().getMail(player.getUniqueId());
        if (mailbox == null || mailbox.isEmpty()) {
            this.plugin.getMessenger().sendMessage((CommandSender)player, "Your mailbox is already empty.");
            return;
        }
        this.plugin.getChatManager().clearMail(player.getUniqueId());
        this.plugin.getMessenger().sendSuccess((CommandSender)player, "Your mailbox has been cleared.");
    }
}

