/*
 * Decompiled with CFR 0.152.
 */
package dev.ajaretro.foliaCore.commands;

import dev.ajaretro.foliaCore.FoliaCore;
import dev.ajaretro.foliaCore.managers.TeleportManager;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class DelHomeCommand
implements CommandExecutor {
    private final FoliaCore plugin;
    private final TeleportManager tm;

    public DelHomeCommand(FoliaCore plugin) {
        this.plugin = plugin;
        this.tm = plugin.getTeleportManager();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            this.plugin.getMessenger().sendError(sender, "This command can only be run by a player.");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("foliacore.delhome")) {
            this.plugin.getMessenger().sendError((CommandSender)player, "You do not have permission to delete a home.");
            return true;
        }
        if (args.length == 0) {
            this.plugin.getMessenger().sendError((CommandSender)player, "Usage: /delhome <name>");
            return true;
        }
        String homeName = args[0];
        if (this.tm.getHome(player.getUniqueId(), homeName) == null) {
            this.plugin.getMessenger().sendError((CommandSender)player, "Home '" + String.valueOf(ChatColor.GOLD) + homeName + String.valueOf(ChatColor.RED) + "' not found.");
            return true;
        }
        this.tm.deleteHome(player.getUniqueId(), homeName);
        this.plugin.getMessenger().sendSuccess((CommandSender)player, "Home '" + String.valueOf(ChatColor.GOLD) + homeName + String.valueOf(ChatColor.GREEN) + "' has been deleted.");
        return true;
    }
}

