/*
 * Decompiled with CFR 0.152.
 */
package dev.ajaretro.foliaCore;

import dev.ajaretro.foliaCore.commands.BalanceCommand;
import dev.ajaretro.foliaCore.commands.BlockCommand;
import dev.ajaretro.foliaCore.commands.ChatCommand;
import dev.ajaretro.foliaCore.commands.CreateKitCommand;
import dev.ajaretro.foliaCore.commands.DelHomeCommand;
import dev.ajaretro.foliaCore.commands.DelWarpCommand;
import dev.ajaretro.foliaCore.commands.DeleteKitCommand;
import dev.ajaretro.foliaCore.commands.EcoCommand;
import dev.ajaretro.foliaCore.commands.GpsCommand;
import dev.ajaretro.foliaCore.commands.HomeCommand;
import dev.ajaretro.foliaCore.commands.HomesCommand;
import dev.ajaretro.foliaCore.commands.KitCommand;
import dev.ajaretro.foliaCore.commands.MailCommand;
import dev.ajaretro.foliaCore.commands.MarkerCommand;
import dev.ajaretro.foliaCore.commands.MsgCommand;
import dev.ajaretro.foliaCore.commands.MuteCommand;
import dev.ajaretro.foliaCore.commands.PayCommand;
import dev.ajaretro.foliaCore.commands.ReplyCommand;
import dev.ajaretro.foliaCore.commands.SetHomeCommand;
import dev.ajaretro.foliaCore.commands.SetSpawnCommand;
import dev.ajaretro.foliaCore.commands.SetWarpCommand;
import dev.ajaretro.foliaCore.commands.SpawnCommand;
import dev.ajaretro.foliaCore.commands.TeamCommand;
import dev.ajaretro.foliaCore.commands.TpAcceptCommand;
import dev.ajaretro.foliaCore.commands.TpDenyCommand;
import dev.ajaretro.foliaCore.commands.TpaCommand;
import dev.ajaretro.foliaCore.commands.TpaHereCommand;
import dev.ajaretro.foliaCore.commands.UnblockCommand;
import dev.ajaretro.foliaCore.commands.UnmuteCommand;
import dev.ajaretro.foliaCore.commands.WarpCommand;
import dev.ajaretro.foliaCore.commands.WarpsCommand;
import dev.ajaretro.foliaCore.listeners.ChatListener;
import dev.ajaretro.foliaCore.listeners.KitGUIListener;
import dev.ajaretro.foliaCore.listeners.MailListener;
import dev.ajaretro.foliaCore.listeners.PlayerGpsListener;
import dev.ajaretro.foliaCore.listeners.PlayerMoveListener;
import dev.ajaretro.foliaCore.managers.ChatManager;
import dev.ajaretro.foliaCore.managers.EconomyManager;
import dev.ajaretro.foliaCore.managers.KitManager;
import dev.ajaretro.foliaCore.managers.MarkerManager;
import dev.ajaretro.foliaCore.managers.TeamManager;
import dev.ajaretro.foliaCore.managers.TeleportManager;
import dev.ajaretro.foliaCore.managers.WarpManager;
import dev.ajaretro.foliaCore.utils.Messenger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class FoliaCore
extends JavaPlugin {
    private static FoliaCore instance;
    private ChatManager chatManager;
    private TeleportManager teleportManager;
    private TeamManager teamManager;
    private KitManager kitManager;
    private WarpManager warpManager;
    private MarkerManager markerManager;
    private EconomyManager economyManager;
    private Messenger messenger;

    public void onEnable() {
        instance = this;
        this.loadManagers();
        this.loadListeners();
        this.loadCommands();
        this.sendBloodRedMessage("=========================================");
        this.sendBloodRedMessage(" FoliaCore by AJARETRO is ALIVE! ");
        this.sendBloodRedMessage(" We are running on Folia!");
        this.sendBloodRedMessage("=========================================");
    }

    public void onDisable() {
        this.saveManagers();
        this.sendBloodRedMessage("FoliaCore by AJARETRO is shutting down...");
    }

    private void loadManagers() {
        this.chatManager = new ChatManager(this);
        this.chatManager.load();
        this.teleportManager = new TeleportManager(this);
        this.teleportManager.load();
        this.teamManager = new TeamManager(this);
        this.teamManager.load();
        this.kitManager = new KitManager(this);
        this.kitManager.load();
        this.warpManager = new WarpManager(this);
        this.warpManager.load();
        this.markerManager = new MarkerManager(this);
        this.markerManager.load();
        this.economyManager = new EconomyManager(this);
        this.economyManager.load();
        this.messenger = new Messenger("&l[ &4AJA_RETRO/&3FoliaCore&f ]");
    }

    private void saveManagers() {
        this.chatManager.saveData();
        this.teleportManager.saveData();
        this.teamManager.saveData();
        this.kitManager.saveData();
        this.warpManager.saveData();
        this.markerManager.saveData();
    }

    private void loadListeners() {
        this.getServer().getPluginManager().registerEvents((Listener)new ChatListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new MailListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerMoveListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new KitGUIListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerGpsListener(this), (Plugin)this);
    }

    private void loadCommands() {
        this.getCommand("mute").setExecutor((CommandExecutor)new MuteCommand(this));
        this.getCommand("unmute").setExecutor((CommandExecutor)new UnmuteCommand(this));
        this.getCommand("msg").setExecutor((CommandExecutor)new MsgCommand(this));
        this.getCommand("reply").setExecutor((CommandExecutor)new ReplyCommand(this));
        this.getCommand("block").setExecutor((CommandExecutor)new BlockCommand(this));
        this.getCommand("unblock").setExecutor((CommandExecutor)new UnblockCommand(this));
        this.getCommand("mail").setExecutor((CommandExecutor)new MailCommand(this));
        this.getCommand("chat").setExecutor((CommandExecutor)new ChatCommand(this));
        this.getCommand("sethome").setExecutor((CommandExecutor)new SetHomeCommand(this));
        this.getCommand("home").setExecutor((CommandExecutor)new HomeCommand(this));
        this.getCommand("delhome").setExecutor((CommandExecutor)new DelHomeCommand(this));
        this.getCommand("homes").setExecutor((CommandExecutor)new HomesCommand(this));
        this.getCommand("tpa").setExecutor((CommandExecutor)new TpaCommand(this));
        this.getCommand("tpahere").setExecutor((CommandExecutor)new TpaHereCommand(this));
        this.getCommand("tpaccept").setExecutor((CommandExecutor)new TpAcceptCommand(this));
        this.getCommand("tpdeny").setExecutor((CommandExecutor)new TpDenyCommand(this));
        this.getCommand("setspawn").setExecutor((CommandExecutor)new SetSpawnCommand(this));
        this.getCommand("spawn").setExecutor((CommandExecutor)new SpawnCommand(this));
        this.getCommand("team").setExecutor((CommandExecutor)new TeamCommand(this));
        this.getCommand("kit").setExecutor((CommandExecutor)new KitCommand(this));
        this.getCommand("createkit").setExecutor((CommandExecutor)new CreateKitCommand(this));
        this.getCommand("delkit").setExecutor((CommandExecutor)new DeleteKitCommand(this));
        this.getCommand("marker").setExecutor((CommandExecutor)new MarkerCommand(this));
        this.getCommand("gps").setExecutor((CommandExecutor)new GpsCommand(this));
        this.getCommand("setwarp").setExecutor((CommandExecutor)new SetWarpCommand(this));
        this.getCommand("delwarp").setExecutor((CommandExecutor)new DelWarpCommand(this));
        this.getCommand("warp").setExecutor((CommandExecutor)new WarpCommand(this));
        this.getCommand("warps").setExecutor((CommandExecutor)new WarpsCommand(this));
        this.getCommand("balance").setExecutor((CommandExecutor)new BalanceCommand(this));
        this.getCommand("pay").setExecutor((CommandExecutor)new PayCommand(this));
        this.getCommand("eco").setExecutor((CommandExecutor)new EcoCommand(this));
    }

    private void sendBloodRedMessage(String message) {
        Bukkit.getConsoleSender().sendMessage(String.valueOf(ChatColor.DARK_RED) + message);
    }

    public static FoliaCore getInstance() {
        return instance;
    }

    public ChatManager getChatManager() {
        return this.chatManager;
    }

    public TeleportManager getTeleportManager() {
        return this.teleportManager;
    }

    public TeamManager getTeamManager() {
        return this.teamManager;
    }

    public KitManager getKitManager() {
        return this.kitManager;
    }

    public WarpManager getWarpManager() {
        return this.warpManager;
    }

    public MarkerManager getMarkerManager() {
        return this.markerManager;
    }

    public EconomyManager getEconomyManager() {
        return this.economyManager;
    }

    public Messenger getMessenger() {
        return this.messenger;
    }
}

