/*
 * Decompiled with CFR 0.152.
 */
package dev.ajaretro.circuitBreaker;

import dev.ajaretro.circuitBreaker.CircuitBreaker;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Vehicle;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class LagManager {
    private final CircuitBreaker plugin;
    private final Map<Chunk, Integer> strikeList = new ConcurrentHashMap<Chunk, Integer>();
    private final Set<Chunk> frozenChunks = ConcurrentHashMap.newKeySet();
    private final Set<String> ignoredChunks = ConcurrentHashMap.newKeySet();
    private final boolean physicsLagEnabled;
    private final int lagThreshold;
    private final int strikeLimit;
    private final long softResetDuration;
    private final long freezeDuration;
    private final boolean notifyAdmins;
    private final int strikeResetMinutes;
    private final boolean entityCullingEnabled;
    private final int entityThreshold;
    private final long entityScanInterval;
    private final List<String> entityWhitelist;
    private FileConfiguration dataConfig = null;
    private File dataFile = null;

    public LagManager(CircuitBreaker plugin) {
        this.plugin = plugin;
        this.physicsLagEnabled = plugin.getConfig().getBoolean("enabled", true);
        this.lagThreshold = plugin.getConfig().getInt("lag-threshold", 20000);
        this.strikeLimit = plugin.getConfig().getInt("strike-limit", 3);
        this.softResetDuration = plugin.getConfig().getLong("soft-reset-duration-ticks", 200L);
        this.freezeDuration = plugin.getConfig().getLong("freeze-duration-ticks", 6000L);
        this.notifyAdmins = plugin.getConfig().getBoolean("notify-admins", true);
        this.strikeResetMinutes = plugin.getConfig().getInt("strike-reset-minutes", 15);
        this.entityCullingEnabled = plugin.getConfig().getBoolean("entity-culling.enabled", false);
        this.entityThreshold = plugin.getConfig().getInt("entity-culling.threshold", 500);
        this.entityWhitelist = plugin.getConfig().getStringList("entity-culling.whitelist");
        long scanSeconds = plugin.getConfig().getLong("entity-culling.scan-interval-seconds", 15L);
        this.entityScanInterval = scanSeconds * 20L;
        this.loadIgnoredChunks();
        if (this.physicsLagEnabled) {
            this.startTicker();
            if (this.strikeResetMinutes > 0) {
                this.startStrikeResetter();
            }
        } else {
            plugin.getServer().getConsoleSender().sendMessage(String.valueOf(ChatColor.DARK_RED) + "[CircuitBreaker] " + String.valueOf(ChatColor.YELLOW) + "Physics Lag detection is disabled via config.yml.");
        }
        if (this.entityCullingEnabled) {
            this.startEntityScanner();
            plugin.getServer().getConsoleSender().sendMessage(String.valueOf(ChatColor.DARK_RED) + "[CircuitBreaker] " + String.valueOf(ChatColor.GREEN) + "Entity Culler is enabled and running.");
        }
    }

    private void startTicker() {
        new BukkitRunnable(){

            public void run() {
                Map<Chunk, Integer> counts = LagManager.this.plugin.getLagListener().getAndResetCounts();
                for (Map.Entry<Chunk, Integer> entry : counts.entrySet()) {
                    int count;
                    Chunk chunk = entry.getKey();
                    if (LagManager.this.isIgnored(chunk) || (count = entry.getValue().intValue()) <= LagManager.this.lagThreshold) continue;
                    LagManager.this.handleLaggyChunk(chunk, count);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
    }

    private void startStrikeResetter() {
        long resetTicks = (long)(this.strikeResetMinutes * 60) * 20L;
        new BukkitRunnable(){

            public void run() {
                LagManager.this.strikeList.clear();
                LagManager.this.plugin.getServer().getConsoleSender().sendMessage(String.valueOf(ChatColor.DARK_RED) + "[CircuitBreaker] " + String.valueOf(ChatColor.GRAY) + "All chunk strikes have been reset.");
            }
        }.runTaskTimer((Plugin)this.plugin, resetTicks, resetTicks);
        this.plugin.getServer().getConsoleSender().sendMessage(String.valueOf(ChatColor.DARK_RED) + "[CircuitBreaker] " + String.valueOf(ChatColor.GRAY) + "Strike resetter task started. Will clear all strikes every " + this.strikeResetMinutes + " minutes.");
    }

    private void startEntityScanner() {
        new BukkitRunnable(){

            public void run() {
                for (World world : LagManager.this.plugin.getServer().getWorlds()) {
                    for (Chunk chunk : world.getLoadedChunks()) {
                        int culledCount;
                        Entity[] entities;
                        if (LagManager.this.isIgnored(chunk) || (entities = chunk.getEntities()).length <= LagManager.this.entityThreshold || (culledCount = LagManager.this.cullChunk(chunk, entities)) <= 0) continue;
                        String consoleMessage = String.valueOf(ChatColor.DARK_RED) + "[CircuitBreaker] " + String.valueOf(ChatColor.YELLOW) + "Entity Culler removed " + culledCount + " entities from chunk at [" + chunk.getX() + ", " + chunk.getZ() + "] in " + world.getName();
                        LagManager.this.plugin.getServer().getConsoleSender().sendMessage(consoleMessage);
                        if (!LagManager.this.notifyAdmins) continue;
                        String adminMessage = String.valueOf(ChatColor.RED) + "[CircuitBreaker] " + String.valueOf(ChatColor.YELLOW) + "Entity Culler removed " + culledCount + " entities from chunk at [" + chunk.getX() + ", " + chunk.getZ() + "]";
                        Bukkit.broadcast((String)adminMessage, (String)"antilag.notify");
                    }
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, this.entityScanInterval);
    }

    private int cullChunk(Chunk chunk, Entity[] entities) {
        int removedCount = 0;
        for (Entity entity : entities) {
            if (this.isImportant(entity)) continue;
            entity.remove();
            ++removedCount;
        }
        return removedCount;
    }

    private boolean isImportant(Entity entity) {
        String typeName = entity.getType().name();
        for (String whitelistedType : this.entityWhitelist) {
            if (!whitelistedType.equalsIgnoreCase(typeName)) continue;
            return true;
        }
        if (entity.getCustomName() != null) {
            return true;
        }
        if (entity instanceof Tameable && ((Tameable)entity).isTamed()) {
            return true;
        }
        return entity instanceof Vehicle;
    }

    private void handleLaggyChunk(Chunk chunk, int count) {
        if (this.isFrozen(chunk)) {
            return;
        }
        int strikes = this.strikeList.getOrDefault(chunk, 0) + 1;
        this.plugin.getServer().getConsoleSender().sendMessage(String.valueOf(ChatColor.DARK_RED) + "[CircuitBreaker] " + String.valueOf(ChatColor.GRAY) + "Lag detected in chunk [" + chunk.getX() + ", " + chunk.getZ() + "] (" + count + " events). Strike " + strikes + "/" + this.strikeLimit);
        if (strikes >= this.strikeLimit) {
            this.performHardFreeze(chunk);
            this.notifyAdmins(chunk, count);
            this.strikeList.remove(chunk);
        } else {
            this.performSoftReset(chunk);
            this.strikeList.put(chunk, strikes);
        }
    }

    private void performSoftReset(final Chunk chunk) {
        this.plugin.getServer().getConsoleSender().sendMessage(String.valueOf(ChatColor.DARK_RED) + "[CircuitBreaker] " + String.valueOf(ChatColor.GRAY) + "Performing soft reset on chunk [" + chunk.getX() + ", " + chunk.getZ() + "]");
        chunk.unload();
        new BukkitRunnable(){

            public void run() {
                LagManager.this.plugin.getServer().getConsoleSender().sendMessage(String.valueOf(ChatColor.DARK_RED) + "[CircuitBreaker] " + String.valueOf(ChatColor.GRAY) + "Reloading chunk [" + chunk.getX() + ", " + chunk.getZ() + "]");
                chunk.load();
            }
        }.runTaskLater((Plugin)this.plugin, this.softResetDuration);
    }

    private void performHardFreeze(final Chunk chunk) {
        this.plugin.getServer().getConsoleSender().sendMessage(String.valueOf(ChatColor.DARK_RED) + "[CircuitBreaker] " + String.valueOf(ChatColor.YELLOW) + "Persistent lag! Freezing chunk [" + chunk.getX() + ", " + chunk.getZ() + "]");
        this.frozenChunks.add(chunk);
        if (this.freezeDuration > -1L) {
            new BukkitRunnable(){

                public void run() {
                    LagManager.this.plugin.getServer().getConsoleSender().sendMessage(String.valueOf(ChatColor.DARK_RED) + "[CircuitBreaker] " + String.valueOf(ChatColor.GRAY) + "Auto-unfreezing chunk [" + chunk.getX() + ", " + chunk.getZ() + "]");
                    LagManager.this.frozenChunks.remove(chunk);
                }
            }.runTaskLater((Plugin)this.plugin, this.freezeDuration);
        }
    }

    private void notifyAdmins(Chunk chunk, int count) {
        if (!this.notifyAdmins) {
            return;
        }
        String message = String.valueOf(ChatColor.RED) + "[CircuitBreaker] " + String.valueOf(ChatColor.YELLOW) + "Persistent lag (" + count + " events) detected! Chunk at [" + chunk.getX() + ", " + chunk.getZ() + "] in " + chunk.getWorld().getName() + " has been frozen.";
        Bukkit.broadcast((String)message, (String)"antilag.notify");
    }

    private String getChunkIdentifier(Chunk chunk) {
        return chunk.getWorld().getUID().toString() + ":" + chunk.getX() + ":" + chunk.getZ();
    }

    public boolean isFrozen(Chunk chunk) {
        return this.frozenChunks.contains(chunk);
    }

    public boolean isIgnored(Chunk chunk) {
        return this.ignoredChunks.contains(this.getChunkIdentifier(chunk));
    }

    public String getChunkStatus(Chunk chunk) {
        if (this.isFrozen(chunk)) {
            return String.valueOf(ChatColor.RED) + "FROZEN";
        }
        if (this.isIgnored(chunk)) {
            return String.valueOf(ChatColor.GRAY) + "IGNORED (Persistent)";
        }
        if (this.strikeList.containsKey(chunk)) {
            return String.valueOf(ChatColor.YELLOW) + "WATCHED (Strikes: " + String.valueOf(this.strikeList.get(chunk)) + ")";
        }
        return String.valueOf(ChatColor.GREEN) + "NORMAL";
    }

    public boolean manuallyUnfreezeChunk(Chunk chunk) {
        this.strikeList.remove(chunk);
        return this.frozenChunks.remove(chunk);
    }

    public boolean addChunkToIgnoreList(Chunk chunk) {
        this.manuallyUnfreezeChunk(chunk);
        boolean added = this.ignoredChunks.add(this.getChunkIdentifier(chunk));
        if (added) {
            this.saveIgnoredChunks();
        }
        return added;
    }

    public boolean removeChunkFromIgnoreList(Chunk chunk) {
        boolean removed = this.ignoredChunks.remove(this.getChunkIdentifier(chunk));
        if (removed) {
            this.saveIgnoredChunks();
        }
        return removed;
    }

    public void loadIgnoredChunks() {
        if (this.dataFile == null) {
            this.dataFile = new File(this.plugin.getDataFolder(), "data.yml");
        }
        if (!this.dataFile.exists()) {
            this.plugin.saveResource("data.yml", false);
        }
        this.dataConfig = YamlConfiguration.loadConfiguration((File)this.dataFile);
        List ignoredList = this.dataConfig.getStringList("ignored-chunks");
        this.ignoredChunks.clear();
        this.ignoredChunks.addAll(ignoredList);
        this.plugin.getServer().getConsoleSender().sendMessage(String.valueOf(ChatColor.DARK_RED) + "[CircuitBreaker] " + String.valueOf(ChatColor.GRAY) + "Loaded " + this.ignoredChunks.size() + " ignored chunks from data.yml.");
    }

    public void saveIgnoredChunks() {
        if (this.dataConfig == null || this.dataFile == null) {
            this.loadIgnoredChunks();
        }
        try {
            this.dataConfig.set("ignored-chunks", new ArrayList<String>(this.ignoredChunks));
            this.dataConfig.save(this.dataFile);
        }
        catch (IOException e) {
            this.plugin.getServer().getConsoleSender().sendMessage(String.valueOf(ChatColor.DARK_RED) + "[CircuitBreaker] " + String.valueOf(ChatColor.RED) + "Could not save ignored chunks to data.yml!");
            e.printStackTrace();
        }
    }
}

