/*
 * Decompiled with CFR 0.152.
 */
package dev.ajaretro.circuitBreaker;

import dev.ajaretro.circuitBreaker.CircuitBreaker;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class LagManager {
    private final CircuitBreaker plugin;
    private final Map<Chunk, Integer> strikeList = new ConcurrentHashMap<Chunk, Integer>();
    private final Set<Chunk> frozenChunks = ConcurrentHashMap.newKeySet();
    private final Set<String> ignoredChunks = ConcurrentHashMap.newKeySet();
    private final boolean pluginEnabled;
    private final int lagThreshold;
    private final int strikeLimit;
    private final long softResetDuration;
    private final long freezeDuration;
    private final boolean notifyAdmins;
    private final int strikeResetMinutes;
    private FileConfiguration dataConfig = null;
    private File dataFile = null;

    public LagManager(CircuitBreaker plugin) {
        this.plugin = plugin;
        this.pluginEnabled = plugin.getConfig().getBoolean("enabled", true);
        this.lagThreshold = plugin.getConfig().getInt("lag-threshold", 5000);
        this.strikeLimit = plugin.getConfig().getInt("strike-limit", 3);
        this.softResetDuration = plugin.getConfig().getLong("soft-reset-duration-ticks", 200L);
        this.freezeDuration = plugin.getConfig().getLong("freeze-duration-ticks", 6000L);
        this.notifyAdmins = plugin.getConfig().getBoolean("notify-admins", true);
        this.strikeResetMinutes = plugin.getConfig().getInt("strike-reset-minutes", 15);
        this.loadIgnoredChunks();
        if (this.pluginEnabled) {
            this.startTicker();
            if (this.strikeResetMinutes > 0) {
                this.startStrikeResetter();
            } else {
                plugin.getLogger().info("Strike resetting is disabled via config.");
            }
        } else {
            plugin.getLogger().warning("CircuitBreaker is disabled via config.yml.");
        }
    }

    private void startTicker() {
        new BukkitRunnable(){

            public void run() {
                Map<Chunk, Integer> counts = LagManager.this.plugin.getLagListener().getAndResetCounts();
                for (Map.Entry<Chunk, Integer> entry : counts.entrySet()) {
                    int count;
                    Chunk chunk = entry.getKey();
                    if (LagManager.this.isIgnored(chunk) || (count = entry.getValue().intValue()) <= LagManager.this.lagThreshold) continue;
                    LagManager.this.handleLaggyChunk(chunk, count);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
    }

    private void startStrikeResetter() {
        long resetTicks = (long)(this.strikeResetMinutes * 60) * 20L;
        new BukkitRunnable(){

            public void run() {
                LagManager.this.strikeList.clear();
                LagManager.this.plugin.getLogger().info("All chunk strikes have been reset.");
            }
        }.runTaskTimer((Plugin)this.plugin, resetTicks, resetTicks);
        this.plugin.getLogger().info("Strike resetter task started. Will clear all strikes every " + this.strikeResetMinutes + " minutes.");
    }

    private void handleLaggyChunk(Chunk chunk, int count) {
        if (this.isFrozen(chunk)) {
            return;
        }
        int strikes = this.strikeList.getOrDefault(chunk, 0) + 1;
        this.plugin.getLogger().info("Lag detected in chunk [" + chunk.getX() + ", " + chunk.getZ() + "] (" + count + " events). Strike " + strikes + "/" + this.strikeLimit);
        if (strikes >= this.strikeLimit) {
            this.performHardFreeze(chunk);
            this.notifyAdmins(chunk, count);
            this.strikeList.remove(chunk);
        } else {
            this.performSoftReset(chunk);
            this.strikeList.put(chunk, strikes);
        }
    }

    private void performSoftReset(final Chunk chunk) {
        this.plugin.getLogger().info("Performing soft reset on chunk [" + chunk.getX() + ", " + chunk.getZ() + "]");
        chunk.unload();
        new BukkitRunnable(){

            public void run() {
                LagManager.this.plugin.getLogger().info("Reloading chunk [" + chunk.getX() + ", " + chunk.getZ() + "]");
                chunk.load();
            }
        }.runTaskLater((Plugin)this.plugin, this.softResetDuration);
    }

    private void performHardFreeze(final Chunk chunk) {
        this.plugin.getLogger().warning("Persistent lag! Freezing chunk [" + chunk.getX() + ", " + chunk.getZ() + "]");
        this.frozenChunks.add(chunk);
        if (this.freezeDuration > -1L) {
            new BukkitRunnable(){

                public void run() {
                    LagManager.this.plugin.getLogger().info("Auto-unfreezing chunk [" + chunk.getX() + ", " + chunk.getZ() + "]");
                    LagManager.this.frozenChunks.remove(chunk);
                }
            }.runTaskLater((Plugin)this.plugin, this.freezeDuration);
        }
    }

    private void notifyAdmins(Chunk chunk, int count) {
        if (!this.notifyAdmins) {
            return;
        }
        String message = String.valueOf(ChatColor.RED) + "[CircuitBreaker] " + String.valueOf(ChatColor.YELLOW) + "Persistent lag (" + count + " events) detected! Chunk at [" + chunk.getX() + ", " + chunk.getZ() + "] in " + chunk.getWorld().getName() + " has been frozen.";
        Bukkit.broadcast((String)message, (String)"antilag.notify");
    }

    private String getChunkIdentifier(Chunk chunk) {
        return chunk.getWorld().getUID().toString() + ":" + chunk.getX() + ":" + chunk.getZ();
    }

    public boolean isFrozen(Chunk chunk) {
        return this.frozenChunks.contains(chunk);
    }

    public boolean isIgnored(Chunk chunk) {
        return this.ignoredChunks.contains(this.getChunkIdentifier(chunk));
    }

    public String getChunkStatus(Chunk chunk) {
        if (this.isFrozen(chunk)) {
            return String.valueOf(ChatColor.RED) + "FROZEN";
        }
        if (this.isIgnored(chunk)) {
            return String.valueOf(ChatColor.GRAY) + "IGNORED (Persistent)";
        }
        if (this.strikeList.containsKey(chunk)) {
            return String.valueOf(ChatColor.YELLOW) + "WATCHED (Strikes: " + String.valueOf(this.strikeList.get(chunk)) + ")";
        }
        return String.valueOf(ChatColor.GREEN) + "NORMAL";
    }

    public boolean manuallyUnfreezeChunk(Chunk chunk) {
        this.strikeList.remove(chunk);
        return this.frozenChunks.remove(chunk);
    }

    public boolean addChunkToIgnoreList(Chunk chunk) {
        this.manuallyUnfreezeChunk(chunk);
        boolean added = this.ignoredChunks.add(this.getChunkIdentifier(chunk));
        if (added) {
            this.saveIgnoredChunks();
        }
        return added;
    }

    public boolean removeChunkFromIgnoreList(Chunk chunk) {
        boolean removed = this.ignoredChunks.remove(this.getChunkIdentifier(chunk));
        if (removed) {
            this.saveIgnoredChunks();
        }
        return removed;
    }

    public void loadIgnoredChunks() {
        if (this.dataFile == null) {
            this.dataFile = new File(this.plugin.getDataFolder(), "data.yml");
        }
        if (!this.dataFile.exists()) {
            this.plugin.saveResource("data.yml", false);
        }
        this.dataConfig = YamlConfiguration.loadConfiguration((File)this.dataFile);
        List ignoredList = this.dataConfig.getStringList("ignored-chunks");
        this.ignoredChunks.clear();
        this.ignoredChunks.addAll(ignoredList);
        this.plugin.getLogger().info("Loaded " + this.ignoredChunks.size() + " ignored chunks from data.yml.");
    }

    public void saveIgnoredChunks() {
        if (this.dataConfig == null || this.dataFile == null) {
            this.loadIgnoredChunks();
        }
        try {
            this.dataConfig.set("ignored-chunks", new ArrayList<String>(this.ignoredChunks));
            this.dataConfig.save(this.dataFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save ignored chunks to data.yml!");
            e.printStackTrace();
        }
    }
}

