/*
 * Decompiled with CFR 0.152.
 */
package dev.ajaretro.circuitBreaker;

import dev.ajaretro.circuitBreaker.CircuitBreaker;
import dev.ajaretro.circuitBreaker.LagManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Chunk;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPhysicsEvent;

public class LagListener
implements Listener {
    private final CircuitBreaker plugin;
    private final Map<Chunk, Integer> eventCounter = new ConcurrentHashMap<Chunk, Integer>();

    public LagListener(CircuitBreaker plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onBlockPhysics(BlockPhysicsEvent event) {
        Chunk chunk = event.getBlock().getChunk();
        LagManager manager = this.plugin.getLagManager();
        if (manager.isFrozen(chunk)) {
            event.setCancelled(true);
            return;
        }
        if (manager.isIgnored(chunk)) {
            return;
        }
        this.eventCounter.compute(chunk, (c, count) -> count == null ? 1 : count + 1);
    }

    public Map<Chunk, Integer> getAndResetCounts() {
        ConcurrentHashMap<Chunk, Integer> countsSnapshot = new ConcurrentHashMap<Chunk, Integer>(this.eventCounter);
        this.eventCounter.clear();
        return countsSnapshot;
    }
}

