/*
 * Decompiled with CFR 0.152.
 */
package dev.ajaretro.circuitBreaker;

import dev.ajaretro.circuitBreaker.CircuitBreaker;
import dev.ajaretro.circuitBreaker.LagManager;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class CircuitBreakerCommand
implements CommandExecutor,
TabCompleter {
    private final CircuitBreaker plugin;
    private final String prefix = String.valueOf(ChatColor.DARK_RED) + "[" + String.valueOf(ChatColor.RED) + "CB-Admin" + String.valueOf(ChatColor.DARK_RED) + "] " + String.valueOf(ChatColor.YELLOW);

    public CircuitBreakerCommand(CircuitBreaker plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("This command can only be run by a player.");
            return true;
        }
        if (!sender.hasPermission("circuitbreaker.admin")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to use this command.");
            return true;
        }
        Player player = (Player)sender;
        Chunk chunk = player.getLocation().getChunk();
        String chunkCoords = "[" + chunk.getX() + ", " + chunk.getZ() + "]";
        if (args.length == 0) {
            this.sendHelp((CommandSender)player);
            return true;
        }
        String subCommand = args[0].toLowerCase();
        LagManager manager = this.plugin.getLagManager();
        switch (subCommand) {
            case "unfreeze": {
                if (manager.manuallyUnfreezeChunk(chunk)) {
                    player.sendMessage(this.prefix + "Chunk " + chunkCoords + " has been manually unfrozen.");
                    break;
                }
                player.sendMessage(this.prefix + "Chunk " + chunkCoords + " was not frozen.");
                break;
            }
            case "ignore": {
                if (manager.addChunkToIgnoreList(chunk)) {
                    player.sendMessage(this.prefix + "Chunk " + chunkCoords + " will now be ignored.");
                    break;
                }
                player.sendMessage(this.prefix + "Chunk " + chunkCoords + " is already being ignored.");
                break;
            }
            case "unignore": {
                if (manager.removeChunkFromIgnoreList(chunk)) {
                    player.sendMessage(this.prefix + "Chunk " + chunkCoords + " is no longer being ignored.");
                    break;
                }
                player.sendMessage(this.prefix + "Chunk " + chunkCoords + " was not on the ignore list.");
                break;
            }
            case "status": {
                String status = manager.getChunkStatus(chunk);
                player.sendMessage(this.prefix + "Chunk " + chunkCoords + " status: " + status);
                break;
            }
            default: {
                this.sendHelp((CommandSender)player);
            }
        }
        return true;
    }

    private void sendHelp(CommandSender sender) {
        sender.sendMessage(this.prefix + "--- CircuitBreaker Admin ---");
        sender.sendMessage(String.valueOf(ChatColor.AQUA) + "/cb status" + String.valueOf(ChatColor.GRAY) + " - Checks the status of your current chunk.");
        sender.sendMessage(String.valueOf(ChatColor.AQUA) + "/cb unfreeze" + String.valueOf(ChatColor.GRAY) + " - Manually unfreezes your current chunk.");
        sender.sendMessage(String.valueOf(ChatColor.AQUA) + "/cb ignore" + String.valueOf(ChatColor.GRAY) + " - Makes the plugin ignore your current chunk.");
        sender.sendMessage(String.valueOf(ChatColor.AQUA) + "/cb unignore" + String.valueOf(ChatColor.GRAY) + " - Removes your current chunk from the ignore list.");
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            List<String> commands = Arrays.asList("status", "unfreeze", "ignore", "unignore", "help");
            return commands.stream().filter(s -> s.startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        return null;
    }
}

