/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.property.entity;

import me.m56738.easyarmorstands.api.property.Property;
import me.m56738.easyarmorstands.api.property.type.EntityPropertyTypes;
import me.m56738.easyarmorstands.api.property.type.PropertyType;
import me.m56738.easyarmorstands.capability.entityscale.EntityScaleCapability;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public class EntityScaleProperty
implements Property<Double> {
    private final LivingEntity entity;
    private final EntityScaleCapability capability;

    public EntityScaleProperty(LivingEntity entity, EntityScaleCapability capability) {
        this.entity = entity;
        this.capability = capability;
    }

    @Override
    @NotNull
    public PropertyType<Double> getType() {
        return EntityPropertyTypes.SCALE;
    }

    @Override
    @NotNull
    public Double getValue() {
        return this.capability.getScale(this.entity);
    }

    @Override
    public boolean setValue(@NotNull Double value) {
        if (!this.capability.hasScale(this.entity)) {
            return false;
        }
        this.capability.setScale(this.entity, value);
        return true;
    }
}

