/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.property;

import java.util.Objects;
import me.m56738.easyarmorstands.api.element.Element;
import me.m56738.easyarmorstands.api.property.PendingChange;
import me.m56738.easyarmorstands.api.property.Property;
import me.m56738.easyarmorstands.api.property.type.PropertyType;
import me.m56738.easyarmorstands.history.ChangeTracker;
import me.m56738.easyarmorstands.property.TrackedPendingChangeWrapper;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TrackedPropertyWrapper<T>
implements Property<T> {
    private final ChangeTracker tracker;
    private final Element element;
    private final Property<T> property;

    TrackedPropertyWrapper(ChangeTracker tracker, Element element, Property<T> property) {
        this.tracker = tracker;
        this.element = element;
        this.property = property;
    }

    @Override
    @NotNull
    public PropertyType<T> getType() {
        return this.property.getType();
    }

    @Override
    @NotNull
    public T getValue() {
        return this.property.getValue();
    }

    @Override
    public boolean setValue(@NotNull T value) {
        Objects.requireNonNull(value);
        T oldValue = this.property.getValue();
        if (Objects.equals(oldValue, value)) {
            return true;
        }
        if (!this.property.setValue(value)) {
            return false;
        }
        this.tracker.recordChange(this.element, this.property, oldValue, value);
        return true;
    }

    @Override
    @Nullable
    public PendingChange prepareChange(@NotNull T value) {
        PendingChange change = this.property.prepareChange(value);
        if (change == null) {
            return null;
        }
        return new TrackedPendingChangeWrapper<T>(this.tracker, this.element, this.property, value, change);
    }

    @Override
    public boolean canChange(@NotNull Player player) {
        return this.property.canChange(player);
    }
}

