/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.lib.gizmo.bukkit.particle;

import java.util.ArrayList;
import java.util.List;
import me.m56738.easyarmorstands.lib.gizmo.AbstractCircleGizmo;
import me.m56738.easyarmorstands.lib.gizmo.api.color.GizmoColor;
import me.m56738.easyarmorstands.lib.gizmo.bukkit.particle.ParticleSpawner;
import me.m56738.easyarmorstands.lib.joml.Math;
import me.m56738.easyarmorstands.lib.joml.Quaterniondc;
import me.m56738.easyarmorstands.lib.joml.Vector3d;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ParticleCircleGizmo
extends AbstractCircleGizmo {
    private final ParticleSpawner particleSpawner;
    private final List<Vector3d> positions = new ArrayList<Vector3d>();
    private boolean visible;

    public ParticleCircleGizmo(ParticleSpawner particleSpawner) {
        this.particleSpawner = particleSpawner;
    }

    @Override
    public void show() {
        this.visible = true;
    }

    @Override
    public void update() {
        if (this.checkAndClearDirty()) {
            this.updatePositions();
        }
        if (this.visible) {
            GizmoColor color = this.getColor();
            double width = this.getWidth();
            for (Vector3d position : this.positions) {
                this.particleSpawner.spawnParticle(position, color, width);
            }
        }
    }

    @Override
    public void hide() {
        this.visible = false;
    }

    private void updatePositions() {
        double radius = this.getRadius();
        Vector3d axis = new Vector3d(this.getAxis().direction());
        Vector3d offset = new Vector3d(this.getAxis().next().direction()).mul(radius);
        Quaterniondc rotation = this.getRotation();
        axis.rotate(rotation);
        offset.rotate(rotation);
        double axisX = axis.x();
        double axisY = axis.y();
        double axisZ = axis.z();
        double circumference = java.lang.Math.PI * 2 * radius;
        double density = this.particleSpawner.getDensity(this.getWidth());
        int count = Math.clamp(0, 100, (int)Math.round(circumference * density));
        while (this.positions.size() < count) {
            this.positions.add(new Vector3d());
        }
        while (this.positions.size() > count) {
            this.positions.remove(this.positions.size() - 1);
        }
        double angle = java.lang.Math.PI * 2 / (double)count;
        for (int i = 0; i < count; ++i) {
            offset.rotateAxis(angle, axisX, axisY, axisZ);
            this.getPosition().add(offset, this.positions.get(i));
        }
    }
}

