/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.lib.gizmo.bukkit.display;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import me.m56738.easyarmorstands.lib.joml.Quaterniondc;
import me.m56738.easyarmorstands.lib.joml.Vector3dc;
import org.bukkit.util.Transformation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class JOMLMapper {
    private final MethodHandle createVector3f;
    private final MethodHandle createQuaternionf;
    private final MethodHandle createTransformation;

    public JOMLMapper() throws Throwable {
        String joml = String.join((CharSequence)".", "org", "joml");
        Class<?> vectorClass = Class.forName(joml + ".Vector3f");
        Class<?> quaternionClass = Class.forName(joml + ".Quaternionf");
        this.createVector3f = MethodHandles.publicLookup().findConstructor(vectorClass, MethodType.methodType(Void.TYPE, Float.TYPE, Float.TYPE, Float.TYPE));
        this.createQuaternionf = MethodHandles.publicLookup().findConstructor(quaternionClass, MethodType.methodType(Void.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE));
        this.createTransformation = MethodHandles.publicLookup().findConstructor(Transformation.class, MethodType.methodType(Void.TYPE, vectorClass, quaternionClass, vectorClass, quaternionClass));
    }

    @NotNull
    public Transformation createTransformation(@NotNull Vector3dc translation, @NotNull Quaterniondc leftRotation, @NotNull Vector3dc scale, @NotNull Quaterniondc rightRotation) {
        try {
            return this.createTransformation.invoke(this.createVector3f(translation), this.createQuaternionf(leftRotation), this.createVector3f(scale), this.createQuaternionf(rightRotation));
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private Object createVector3f(Vector3dc value) throws Throwable {
        return this.createVector3f.invoke((float)value.x(), (float)value.y(), (float)value.z());
    }

    private Object createQuaternionf(Quaterniondc value) throws Throwable {
        return this.createQuaternionf.invoke((float)value.x(), (float)value.y(), (float)value.z(), (float)value.w());
    }
}

