/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.lib.gizmo;

import java.util.Objects;
import me.m56738.easyarmorstands.lib.gizmo.api.Gizmo;
import me.m56738.easyarmorstands.lib.gizmo.api.color.GizmoColor;
import me.m56738.easyarmorstands.lib.joml.Quaterniond;
import me.m56738.easyarmorstands.lib.joml.Quaterniondc;
import me.m56738.easyarmorstands.lib.joml.Vector3d;
import me.m56738.easyarmorstands.lib.joml.Vector3dc;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public abstract class AbstractGizmo
implements Gizmo {
    private final Vector3d position = new Vector3d();
    private final Vector3d offset = new Vector3d();
    private final Quaterniond rotation = new Quaterniond();
    private GizmoColor color = DEFAULT_COLOR;
    private boolean dirty = true;

    @Override
    @NotNull
    public Vector3dc getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(@NotNull Vector3dc position) {
        if (!Objects.equals(this.position, position)) {
            this.position.set(position);
            this.markDirty();
        }
    }

    @Override
    @NotNull
    public Vector3dc getOffset() {
        return this.offset;
    }

    @Override
    public void setOffset(@NotNull Vector3dc offset) {
        if (!Objects.equals(this.offset, offset)) {
            this.offset.set(offset);
            this.markDirty();
        }
    }

    @Override
    @NotNull
    public Quaterniondc getRotation() {
        return this.rotation;
    }

    @Override
    public void setRotation(@NotNull Quaterniondc rotation) {
        if (!Objects.equals(this.rotation, rotation)) {
            this.rotation.set(rotation);
            this.markDirty();
        }
    }

    @Override
    @NotNull
    public GizmoColor getColor() {
        return this.color;
    }

    @Override
    public void setColor(@NotNull GizmoColor color) {
        if (!Objects.equals(this.color, color)) {
            this.color = color;
            this.markDirty();
        }
    }

    protected void markDirty() {
        this.dirty = true;
    }

    protected boolean checkAndClearDirty() {
        boolean dirty = this.dirty;
        this.dirty = false;
        return dirty;
    }
}

