/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.lib.cloud.permission;

import java.util.function.Predicate;
import me.m56738.easyarmorstands.lib.cloud.key.CloudKey;
import me.m56738.easyarmorstands.lib.cloud.key.CloudKeyHolder;
import me.m56738.easyarmorstands.lib.cloud.permission.Permission;
import me.m56738.easyarmorstands.lib.cloud.permission.PermissionResult;
import me.m56738.easyarmorstands.lib.cloud.permission.WrappingPredicatePermission;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;

@FunctionalInterface
@API(status=API.Status.STABLE)
public interface PredicatePermission<C>
extends Permission,
CloudKeyHolder<Void> {
    public static <C> PredicatePermission<C> of(@NonNull CloudKey<Void> key, @NonNull Predicate<C> predicate) {
        return new WrappingPredicatePermission<C>(key, predicate);
    }

    public static <C> PredicatePermission<C> of(final @NonNull Predicate<C> predicate) {
        return new PredicatePermission<C>(){

            @Override
            public @NonNull PermissionResult testPermission(@NonNull C sender) {
                return PermissionResult.of(predicate.test(sender), this);
            }
        };
    }

    @Override
    default public @NonNull CloudKey<Void> key() {
        return CloudKey.of(this.getClass().getSimpleName());
    }

    @Override
    default public @NonNull String permissionString() {
        return this.key().name();
    }

    @API(status=API.Status.STABLE)
    public @NonNull PermissionResult testPermission(@NonNull C var1);

    @Override
    default public boolean isEmpty() {
        return false;
    }
}

