/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.lands;

import me.angeschossen.lands.api.LandsIntegration;
import me.angeschossen.lands.api.flags.type.RoleFlag;
import me.angeschossen.lands.api.land.Area;
import me.m56738.easyarmorstands.EasyArmorStandsPlugin;
import me.m56738.easyarmorstands.api.element.Element;
import me.m56738.easyarmorstands.api.property.PropertyContainer;
import me.m56738.easyarmorstands.api.region.RegionPrivilegeChecker;
import me.m56738.easyarmorstands.message.Message;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class LandsPrivilegeChecker
implements RegionPrivilegeChecker {
    private final LandsIntegration integration;
    private final RoleFlag flag;

    public LandsPrivilegeChecker(LandsIntegration integration, RoleFlag flag) {
        this.integration = integration;
        this.flag = flag;
    }

    @Override
    public boolean isAllowed(Player player, Location location) {
        if (!location.getChunk().isLoaded()) {
            return false;
        }
        Area area = this.integration.getArea(location);
        if (area == null) {
            return true;
        }
        return area.hasRoleFlag(player.getUniqueId(), this.flag);
    }

    @Override
    public boolean canBypass(Player player) {
        return player.hasPermission("easyarmorstands.lands.bypass");
    }

    @Override
    public void sendCreateError(@NotNull Player player, @NotNull PropertyContainer properties) {
        EasyArmorStandsPlugin.getInstance().getAdventure().player(player).sendMessage(Message.error("easyarmorstands.error.lands.deny-create"));
    }

    @Override
    public void sendDestroyError(@NotNull Player player, @NotNull Element element) {
        EasyArmorStandsPlugin.getInstance().getAdventure().player(player).sendMessage(Message.error("easyarmorstands.error.lands.deny-destroy"));
    }

    @Override
    public void sendEditError(@NotNull Player player, @NotNull Element element) {
        EasyArmorStandsPlugin.getInstance().getAdventure().player(player).sendMessage(Message.error("easyarmorstands.error.lands.deny-select"));
    }
}

