/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.history;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import me.m56738.easyarmorstands.api.element.Element;
import me.m56738.easyarmorstands.api.property.Property;
import me.m56738.easyarmorstands.api.property.type.PropertyType;
import me.m56738.easyarmorstands.history.ChangeKey;
import me.m56738.easyarmorstands.history.History;
import me.m56738.easyarmorstands.history.action.Action;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import org.jetbrains.annotations.Nullable;

public class ChangeTracker {
    private final History history;
    private final Map<ChangeKey<?>, Object> originalValues = new HashMap();
    private final Map<ChangeKey<?>, Object> pendingValues = new HashMap();

    public ChangeTracker(History history) {
        this.history = history;
    }

    public void commit(@Nullable Component description) {
        ArrayList<Action> actions = new ArrayList<Action>();
        for (Map.Entry<ChangeKey<?>, Object> entry : this.pendingValues.entrySet()) {
            Object value;
            ChangeKey<?> key = entry.getKey();
            Object oldValue = this.originalValues.get(key);
            if (Objects.equals(oldValue, value = entry.getValue())) continue;
            actions.add(key.createChangeAction(oldValue, value));
        }
        this.history.push(actions, description);
        this.originalValues.clear();
        this.pendingValues.clear();
    }

    public <T> void recordChange(Element element, Property<T> property, T oldValue, T value) {
        PropertyType<T> type = property.getType();
        ChangeKey<T> key = new ChangeKey<T>(element, type);
        this.originalValues.putIfAbsent(key, type.cloneValue(oldValue));
        this.pendingValues.put(key, type.cloneValue(value));
    }
}

