/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.editor.button;

import me.m56738.easyarmorstands.api.editor.Session;
import me.m56738.easyarmorstands.api.editor.button.Button;
import me.m56738.easyarmorstands.api.editor.button.MenuButton;
import me.m56738.easyarmorstands.api.editor.button.PointButton;
import me.m56738.easyarmorstands.api.editor.tool.AxisMoveTool;
import me.m56738.easyarmorstands.api.editor.tool.AxisMoveToolSession;
import me.m56738.easyarmorstands.api.particle.ParticleColor;
import me.m56738.easyarmorstands.editor.node.AxisMoveToolNode;
import me.m56738.easyarmorstands.lib.joml.Vector3dc;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BoxResizeButton
implements MenuButton {
    private final Session session;
    private final Component name;
    private final ParticleColor color;
    private final AxisMoveTool tool;

    public BoxResizeButton(Session session, Component name, ParticleColor color, AxisMoveTool tool) {
        this.session = session;
        this.name = name;
        this.color = color;
        this.tool = tool;
    }

    @Override
    @NotNull
    public Button getButton() {
        PointButton button = new PointButton(this.session, this.tool, this.tool);
        button.setPriority(2);
        button.setColor(this.color);
        return button;
    }

    @Override
    @NotNull
    public Component getName() {
        return this.name;
    }

    @Override
    public void onClick(@NotNull Session session, @Nullable Vector3dc cursor) {
        AxisMoveToolNode node = new AxisMoveToolNode(session, (AxisMoveToolSession)this.tool.start(), this.name, this.color, 3.0, this.tool.getPosition(), this.tool.getRotation(), this.tool.getAxis());
        session.pushNode(node, cursor);
    }
}

