/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.editor.armorstand.button;

import me.m56738.easyarmorstands.api.editor.Session;
import me.m56738.easyarmorstands.api.editor.button.Button;
import me.m56738.easyarmorstands.api.editor.button.MenuButton;
import me.m56738.easyarmorstands.api.editor.button.PointButton;
import me.m56738.easyarmorstands.api.editor.node.Node;
import me.m56738.easyarmorstands.api.particle.ParticleColor;
import me.m56738.easyarmorstands.api.property.PropertyContainer;
import me.m56738.easyarmorstands.editor.EntityPositionProvider;
import me.m56738.easyarmorstands.editor.OffsetProvider;
import me.m56738.easyarmorstands.editor.armorstand.ArmorStandRotationProvider;
import me.m56738.easyarmorstands.editor.armorstand.node.ArmorStandPositionNode;
import me.m56738.easyarmorstands.editor.node.NodeFactory;
import me.m56738.easyarmorstands.element.ArmorStandElement;
import me.m56738.easyarmorstands.lib.joml.Vector3dc;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArmorStandPositionButton
implements MenuButton,
NodeFactory {
    private final Session session;
    private final ParticleColor color;
    private final Component name;
    private final PropertyContainer container;
    private final OffsetProvider offsetProvider;
    private final ArmorStandElement element;

    public ArmorStandPositionButton(Session session, ParticleColor color, Component name, PropertyContainer container, OffsetProvider offsetProvider, ArmorStandElement element) {
        this.session = session;
        this.color = color;
        this.name = name;
        this.container = container;
        this.offsetProvider = offsetProvider;
        this.element = element;
    }

    @Override
    @NotNull
    public Button getButton() {
        PointButton button = new PointButton(this.session, new EntityPositionProvider(this.container, this.offsetProvider), new ArmorStandRotationProvider(this.container));
        button.setPriority(1);
        button.setColor(this.color);
        return button;
    }

    @Override
    @NotNull
    public Component getName() {
        return this.name;
    }

    @Override
    public void onClick(@NotNull Session session, @Nullable Vector3dc cursor) {
        session.pushNode(this.createNode(), cursor);
    }

    @Override
    public Node createNode() {
        return new ArmorStandPositionNode(this.session, this.container, this.offsetProvider, this.element);
    }
}

