/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.editor.armorstand.button;

import java.util.function.Consumer;
import me.m56738.easyarmorstands.api.ArmorStandPart;
import me.m56738.easyarmorstands.api.ArmorStandSize;
import me.m56738.easyarmorstands.api.Axis;
import me.m56738.easyarmorstands.api.editor.EyeRay;
import me.m56738.easyarmorstands.api.editor.Session;
import me.m56738.easyarmorstands.api.editor.button.ButtonResult;
import me.m56738.easyarmorstands.api.editor.node.Node;
import me.m56738.easyarmorstands.api.particle.LineParticle;
import me.m56738.easyarmorstands.api.particle.ParticleColor;
import me.m56738.easyarmorstands.api.property.Property;
import me.m56738.easyarmorstands.api.property.PropertyContainer;
import me.m56738.easyarmorstands.api.property.type.ArmorStandPropertyTypes;
import me.m56738.easyarmorstands.api.property.type.EntityPropertyTypes;
import me.m56738.easyarmorstands.editor.armorstand.node.ArmorStandPartNode;
import me.m56738.easyarmorstands.editor.button.NodeFactoryButton;
import me.m56738.easyarmorstands.element.ArmorStandElement;
import me.m56738.easyarmorstands.lib.joml.Math;
import me.m56738.easyarmorstands.lib.joml.Quaterniond;
import me.m56738.easyarmorstands.lib.joml.Vector3d;
import me.m56738.easyarmorstands.lib.joml.Vector3dc;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import me.m56738.easyarmorstands.util.ArmorStandPartInfo;
import me.m56738.easyarmorstands.util.Util;
import org.bukkit.Location;
import org.bukkit.util.EulerAngle;
import org.jetbrains.annotations.NotNull;

public class ArmorStandPartButton
implements NodeFactoryButton {
    private final Session session;
    private final PropertyContainer container;
    private final ArmorStandPart part;
    private final ArmorStandPartInfo partInfo;
    private final ArmorStandElement element;
    private final Vector3d start = new Vector3d();
    private final Vector3d end = new Vector3d();
    private final Vector3d center = new Vector3d();
    private final Quaterniond rotation = new Quaterniond();
    private final LineParticle particle;
    private final Property<Location> locationProperty;
    private final Property<EulerAngle> poseProperty;
    private final Property<ArmorStandSize> sizeProperty;
    private double scale = 1.0;

    public ArmorStandPartButton(Session session, PropertyContainer container, ArmorStandPart part, ArmorStandElement element) {
        this.session = session;
        this.container = container;
        this.part = part;
        this.partInfo = ArmorStandPartInfo.of(part);
        this.element = element;
        this.particle = session.particleProvider().createLine();
        this.particle.setAxis(Axis.Y);
        this.locationProperty = container.get(EntityPropertyTypes.LOCATION);
        this.poseProperty = container.get(ArmorStandPropertyTypes.POSE.get(part));
        this.sizeProperty = container.get(ArmorStandPropertyTypes.SIZE);
    }

    @Override
    public void update() {
        Location location = this.locationProperty.getValue();
        ArmorStandSize size = this.sizeProperty.getValue();
        double scale = this.element.getScale();
        this.scale = Math.max(1.0, scale);
        Util.fromEuler(this.poseProperty.getValue(), this.rotation).rotateLocalY(-Math.toRadians(location.getYaw()));
        this.partInfo.getOffset(size, scale).rotateY(-Math.toRadians(location.getYaw()), this.start).add(location.getX(), location.getY(), location.getZ());
        this.partInfo.getLength(size, scale).rotate(this.rotation, this.end).add(this.start);
        this.start.lerp(this.end, 0.3333333333333333);
        this.start.lerp(this.end, 0.5, this.center);
    }

    @Override
    public void intersect(@NotNull EyeRay ray, @NotNull @NotNull Consumer<@NotNull ButtonResult> results) {
        Vector3dc intersection = ray.intersectLine(this.start, this.end, this.scale);
        if (intersection != null) {
            results.accept(ButtonResult.of(intersection));
        }
    }

    @Override
    public void updatePreview(boolean focused) {
        this.particle.setRotation(this.rotation);
        this.particle.setCenter(this.center);
        this.particle.setLength(this.center.distance(this.end) * 2.0);
        this.particle.setWidth(0.015625 * this.scale);
        this.particle.setColor(focused ? ParticleColor.YELLOW : ParticleColor.WHITE);
    }

    @Override
    public void showPreview() {
        this.session.addParticle(this.particle);
    }

    @Override
    public void hidePreview() {
        this.session.removeParticle(this.particle);
    }

    @Override
    @NotNull
    public Component getName() {
        return this.partInfo.getDisplayName();
    }

    @Override
    public Node createNode() {
        return new ArmorStandPartNode(this.session, this.container, this.part, this.element);
    }
}

