/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.display.editor.tool;

import me.m56738.easyarmorstands.EasyArmorStandsPlugin;
import me.m56738.easyarmorstands.api.editor.Snapper;
import me.m56738.easyarmorstands.api.editor.tool.ScaleTool;
import me.m56738.easyarmorstands.api.editor.tool.ScaleToolSession;
import me.m56738.easyarmorstands.api.editor.tool.ToolContext;
import me.m56738.easyarmorstands.api.property.Property;
import me.m56738.easyarmorstands.api.property.PropertyContainer;
import me.m56738.easyarmorstands.display.api.property.type.DisplayPropertyTypes;
import me.m56738.easyarmorstands.editor.tool.AbstractToolSession;
import me.m56738.easyarmorstands.lib.joml.Quaterniondc;
import me.m56738.easyarmorstands.lib.joml.Vector3dc;
import me.m56738.easyarmorstands.lib.joml.Vector3f;
import me.m56738.easyarmorstands.lib.joml.Vector3fc;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import me.m56738.easyarmorstands.util.Util;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisplayScaleTool
implements ScaleTool {
    private final ToolContext context;
    private final PropertyContainer properties;
    private final Property<Vector3fc> scaleProperty;

    public DisplayScaleTool(ToolContext context, PropertyContainer properties) {
        this.context = context;
        this.properties = properties;
        this.scaleProperty = properties.get(DisplayPropertyTypes.SCALE);
    }

    @Override
    @NotNull
    public Vector3dc getPosition() {
        return this.context.position().getPosition();
    }

    @Override
    @NotNull
    public Quaterniondc getRotation() {
        return this.context.rotation().getRotation();
    }

    @Override
    @NotNull
    public ScaleToolSession start() {
        return new SessionImpl();
    }

    @Override
    public boolean canUse(@NotNull Player player) {
        return this.scaleProperty.canChange(player);
    }

    private class SessionImpl
    extends AbstractToolSession
    implements ScaleToolSession {
        private final Vector3fc originalScale;
        private final float originalAverage;
        private final Vector3f scale;

        public SessionImpl() {
            super(DisplayScaleTool.this.properties);
            this.originalScale = new Vector3f((Vector3fc)DisplayScaleTool.this.scaleProperty.getValue());
            this.originalAverage = (this.originalScale.x() + this.originalScale.y() + this.originalScale.z()) / 3.0f;
            this.scale = new Vector3f(this.originalScale);
        }

        @Override
        public void setChange(double change) {
            this.originalScale.mul((float)change, this.scale);
            EasyArmorStandsPlugin.getInstance().getConfiguration().limits.displayEntity.clampScale(this.scale);
            DisplayScaleTool.this.scaleProperty.setValue(this.scale);
        }

        @Override
        public double snapChange(double change, @NotNull Snapper context) {
            change *= (double)this.originalAverage;
            change = context.snapOffset(change);
            return change /= (double)this.originalAverage;
        }

        @Override
        public void setValue(double value) {
            this.scale.set(EasyArmorStandsPlugin.getInstance().getConfiguration().limits.displayEntity.clampScale(value));
            DisplayScaleTool.this.scaleProperty.setValue(this.scale);
        }

        @Override
        public void revert() {
            DisplayScaleTool.this.scaleProperty.setValue(this.originalScale);
        }

        @Override
        @Nullable
        public Component getStatus() {
            return Util.formatScale(this.scale);
        }

        @Override
        @Nullable
        public Component getDescription() {
            return null;
        }
    }
}

