/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.display.editor.box;

import me.m56738.easyarmorstands.api.property.Property;
import me.m56738.easyarmorstands.api.property.PropertyContainer;
import me.m56738.easyarmorstands.api.property.type.EntityPropertyTypes;
import me.m56738.easyarmorstands.api.util.BoundingBox;
import me.m56738.easyarmorstands.display.api.property.type.DisplayPropertyTypes;
import me.m56738.easyarmorstands.editor.box.AbstractBoundingBoxEditorSession;
import me.m56738.easyarmorstands.editor.box.BoundingBoxEditor;
import me.m56738.easyarmorstands.editor.box.BoundingBoxEditorSession;
import me.m56738.easyarmorstands.lib.joml.Vector3d;
import me.m56738.easyarmorstands.lib.joml.Vector3dc;
import me.m56738.easyarmorstands.util.Util;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class InteractionBoxEditor
implements BoundingBoxEditor {
    private final PropertyContainer properties;
    private final Property<Location> locationProperty;
    private final Property<Float> widthProperty;
    private final Property<Float> heightProperty;

    public InteractionBoxEditor(PropertyContainer properties) {
        this.properties = properties;
        this.locationProperty = properties.get(EntityPropertyTypes.LOCATION);
        this.widthProperty = properties.get(DisplayPropertyTypes.BOX_WIDTH);
        this.heightProperty = properties.get(DisplayPropertyTypes.BOX_HEIGHT);
    }

    @Override
    public BoundingBox getBoundingBox() {
        return BoundingBox.of((Vector3dc)Util.toVector3d(this.locationProperty.getValue()), this.widthProperty.getValue().floatValue(), this.heightProperty.getValue().floatValue());
    }

    @Override
    public boolean canMove(Player player) {
        return this.locationProperty.canChange(player);
    }

    @Override
    public boolean canResize(Player player) {
        return this.widthProperty.canChange(player) && this.heightProperty.canChange(player);
    }

    @Override
    public BoundingBoxEditorSession start() {
        return new SessionImpl();
    }

    private class SessionImpl
    extends AbstractBoundingBoxEditorSession {
        private final Location originalLocation;
        private final Vector3dc originalPosition;
        private final float originalWidth;
        private final float originalHeight;

        private SessionImpl() {
            super(InteractionBoxEditor.this.properties);
            this.originalLocation = ((Location)InteractionBoxEditor.this.locationProperty.getValue()).clone();
            this.originalPosition = Util.toVector3d(this.originalLocation);
            this.originalWidth = ((Float)InteractionBoxEditor.this.widthProperty.getValue()).floatValue();
            this.originalHeight = ((Float)InteractionBoxEditor.this.heightProperty.getValue()).floatValue();
        }

        @Override
        public BoundingBox getBoundingBox() {
            return InteractionBoxEditor.this.getBoundingBox();
        }

        @Override
        public boolean setCenter(Vector3dc center) {
            Vector3d delta = center.sub(0.0, this.getHeight() / 2.0f, 0.0, new Vector3d()).sub(this.originalPosition);
            Location location = this.originalLocation.clone();
            location.add(delta.x(), delta.y(), delta.z());
            return InteractionBoxEditor.this.locationProperty.setValue(location);
        }

        @Override
        public float getWidth() {
            return ((Float)InteractionBoxEditor.this.widthProperty.getValue()).floatValue();
        }

        @Override
        public boolean setWidth(float width) {
            return InteractionBoxEditor.this.widthProperty.setValue(Float.valueOf(width));
        }

        @Override
        public float getHeight() {
            return ((Float)InteractionBoxEditor.this.heightProperty.getValue()).floatValue();
        }

        @Override
        public boolean setHeight(float height) {
            return InteractionBoxEditor.this.heightProperty.setValue(Float.valueOf(height));
        }

        @Override
        public void revert() {
            InteractionBoxEditor.this.locationProperty.setValue(this.originalLocation);
            InteractionBoxEditor.this.widthProperty.setValue(Float.valueOf(this.originalWidth));
            InteractionBoxEditor.this.heightProperty.setValue(Float.valueOf(this.originalHeight));
        }
    }
}

