/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.config.version;

import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public class Version
implements Comparable<Version> {
    private static final Comparator<Version> COMPARATOR = Comparator.comparingInt(Version::getMajor).thenComparingInt(Version::getMinor).thenComparingInt(Version::getPatch);
    private final int major;
    private final int minor;
    private final int patch;

    public Version(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public static Version parse(String version) {
        String[] parts = version.split("\\D", 4);
        if (parts.length < 2) {
            throw new IllegalArgumentException("Invalid version: " + version);
        }
        int major = Version.parseIntOrZero(parts[0]);
        int minor = Version.parseIntOrZero(parts[1]);
        int patch = minor != 0 && parts.length >= 3 ? Version.parseIntOrZero(parts[2]) : 0;
        return new Version(major, minor, patch);
    }

    private static int parseIntOrZero(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    @Override
    public int compareTo(@NotNull Version other) {
        return COMPARATOR.compare(this, other);
    }

    public String toString() {
        if (this.patch != 0) {
            return this.major + "." + this.minor + "." + this.patch;
        }
        return this.major + "." + this.minor;
    }
}

