/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.config.serializer;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Type;
import java.util.List;
import me.m56738.easyarmorstands.api.util.ItemTemplate;
import me.m56738.easyarmorstands.item.ItemRenderer;
import me.m56738.easyarmorstands.item.SimpleItemTemplate;
import me.m56738.easyarmorstands.lib.configurate.ConfigurationNode;
import me.m56738.easyarmorstands.lib.configurate.serialize.SerializationException;
import me.m56738.easyarmorstands.lib.configurate.serialize.TypeSerializer;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.Nullable;

public class ItemTemplateSerializer
implements TypeSerializer<ItemTemplate> {
    @Nullable
    private final MethodHandle customModelDataSetter = ItemTemplateSerializer.findCustomModelDataSetter();
    @Nullable
    private final MethodHandle hideTooltipSetter = ItemTemplateSerializer.findHideTooltipSetter();

    private static MethodHandle findCustomModelDataSetter() {
        try {
            return MethodHandles.lookup().findVirtual(ItemMeta.class, "setCustomModelData", MethodType.methodType(Void.TYPE, Integer.class));
        }
        catch (ReflectiveOperationException e) {
            return null;
        }
    }

    private static MethodHandle findHideTooltipSetter() {
        try {
            return MethodHandles.lookup().findVirtual(ItemMeta.class, "setHideTooltip", MethodType.methodType(Void.TYPE, Boolean.TYPE));
        }
        catch (ReflectiveOperationException e) {
            return null;
        }
    }

    @Override
    public ItemTemplate deserialize(Type type, ConfigurationNode node) throws SerializationException {
        ConfigurationNode dataNode = node.node("data");
        short data = (short)dataNode.getInt();
        if (data < 0) {
            throw new SerializationException("Data cannot be negative");
        }
        ItemStack template = new ItemStack(node.node("type").get(Material.class, Material.AIR), node.node("amount").getInt(1), data);
        ItemMeta meta = template.getItemMeta();
        if (meta != null) {
            if (this.customModelDataSetter != null) {
                try {
                    this.customModelDataSetter.invoke(meta, node.node("custom-model-data").get(Integer.class));
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.hideTooltipSetter != null) {
                try {
                    this.hideTooltipSetter.invoke(meta, node.node("hide-tooltip").getBoolean());
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            template.setItemMeta(meta);
        }
        String name = node.node("name").getString();
        List<String> description = node.node("description").getList(String.class);
        return new SimpleItemTemplate(template, name, description, TagResolver.empty(), ItemRenderer.button());
    }

    @Override
    public void serialize(Type type, @Nullable ItemTemplate obj, ConfigurationNode node) throws SerializationException {
        throw new SerializationException(new UnsupportedOperationException());
    }
}

