/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.config.serializer;

import java.lang.reflect.Type;
import me.m56738.easyarmorstands.lib.configurate.ConfigurationNode;
import me.m56738.easyarmorstands.lib.configurate.serialize.SerializationException;
import me.m56738.easyarmorstands.lib.configurate.serialize.TypeSerializer;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ColorSerializer
implements TypeSerializer<Color> {
    @Override
    public Color deserialize(Type type, ConfigurationNode node) throws SerializationException {
        if (node.isNull()) {
            return null;
        }
        if (node.isMap()) {
            return Color.fromRGB((int)node.node("red").getInt(), (int)node.node("green").getInt(), (int)node.node("blue").getInt());
        }
        String value = node.getString();
        if (value == null) {
            return null;
        }
        if (value.startsWith("#")) {
            try {
                return Color.fromRGB((int)Integer.parseInt(value.substring(1), 16));
            }
            catch (NumberFormatException e) {
                throw new SerializationException(e);
            }
        }
        try {
            return DyeColor.valueOf((String)value).getColor();
        }
        catch (IllegalArgumentException e) {
            throw new SerializationException(e);
        }
    }

    @Override
    public void serialize(Type type, @Nullable Color obj, ConfigurationNode node) throws SerializationException {
        if (obj == null) {
            node.raw(null);
            return;
        }
        node.node("red").set(obj.getRed());
        node.node("green").set(obj.getGreen());
        node.node("blue").set(obj.getBlue());
    }
}

