/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.command.sender;

import java.util.Locale;
import me.m56738.easyarmorstands.EasyArmorStandsPlugin;
import me.m56738.easyarmorstands.api.element.DestroyableElement;
import me.m56738.easyarmorstands.api.element.EditableElement;
import me.m56738.easyarmorstands.api.element.Element;
import me.m56738.easyarmorstands.api.element.ElementType;
import me.m56738.easyarmorstands.api.event.player.PlayerCreateElementEvent;
import me.m56738.easyarmorstands.api.event.player.PlayerDestroyElementEvent;
import me.m56738.easyarmorstands.api.event.player.PlayerDiscoverElementEvent;
import me.m56738.easyarmorstands.api.event.player.PlayerEditElementEvent;
import me.m56738.easyarmorstands.api.event.player.PlayerEditPropertyEvent;
import me.m56738.easyarmorstands.api.property.Property;
import me.m56738.easyarmorstands.api.property.PropertyContainer;
import me.m56738.easyarmorstands.clipboard.Clipboard;
import me.m56738.easyarmorstands.command.sender.EasCommandSender;
import me.m56738.easyarmorstands.context.ChangeContext;
import me.m56738.easyarmorstands.history.ChangeTracker;
import me.m56738.easyarmorstands.history.History;
import me.m56738.easyarmorstands.lib.kyori.adventure.audience.Audience;
import me.m56738.easyarmorstands.lib.kyori.adventure.identity.Identity;
import me.m56738.easyarmorstands.session.SessionImpl;
import me.m56738.easyarmorstands.util.MainThreadExecutor;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EasPlayer
extends EasCommandSender
implements ChangeContext {
    @NotNull
    private final Player player;
    @Nullable
    private History history;
    @Nullable
    private Clipboard clipboard;

    public EasPlayer(@NotNull Player player, @NotNull Audience audience) {
        super((CommandSender)player, audience);
        this.player = player;
    }

    public EasPlayer(@NotNull Player player) {
        this(player, EasyArmorStandsPlugin.getInstance().getAdventure().player(player));
    }

    @NotNull
    public Player get() {
        return this.player;
    }

    @Override
    @NotNull
    public History history() {
        if (this.history == null) {
            MainThreadExecutor.checkMainThread();
            this.history = EasyArmorStandsPlugin.getInstance().getHistory(this.player);
        }
        return this.history;
    }

    @NotNull
    public Clipboard clipboard() {
        if (this.clipboard == null) {
            MainThreadExecutor.checkMainThread();
            this.clipboard = EasyArmorStandsPlugin.getInstance().getClipboard(this.player);
        }
        return this.clipboard;
    }

    @Override
    @NotNull
    public ChangeTracker tracker() {
        return this.history().getTracker();
    }

    @Override
    @NotNull
    public Locale locale() {
        return this.getOrDefault(Identity.LOCALE, Locale.US);
    }

    @Override
    @NotNull
    public Player player() {
        return this.player;
    }

    @Nullable
    public SessionImpl session() {
        return EasyArmorStandsPlugin.getInstance().sessionManager().getSession(this.player);
    }

    @Override
    public boolean canCreateElement(ElementType type, PropertyContainer properties) {
        if (!type.canSpawn(this.player)) {
            return false;
        }
        PlayerCreateElementEvent event = new PlayerCreateElementEvent(this.player, type, properties);
        Bukkit.getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    @Override
    public boolean canDestroyElement(DestroyableElement element) {
        if (!element.canDestroy(this.player)) {
            return false;
        }
        PlayerDestroyElementEvent event = new PlayerDestroyElementEvent(this.player, element);
        Bukkit.getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    @Override
    public boolean canEditElement(EditableElement element) {
        if (!element.canEdit(this.player)) {
            return false;
        }
        PlayerEditElementEvent event = new PlayerEditElementEvent(this.player, element);
        Bukkit.getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    @Override
    public boolean canDiscoverElement(EditableElement element) {
        if (!element.canEdit(this.player)) {
            return false;
        }
        PlayerDiscoverElementEvent event = new PlayerDiscoverElementEvent(this.player, element);
        Bukkit.getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    @Override
    public <T> boolean canChangeProperty(Element element, Property<T> property, T value) {
        PlayerEditPropertyEvent<T> event = new PlayerEditPropertyEvent<T>(this.player, element, property, property.getValue(), value);
        Bukkit.getPluginManager().callEvent(event);
        return !event.isCancelled();
    }
}

