/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.color;

import me.m56738.easyarmorstands.api.menu.ColorPickerContext;
import me.m56738.easyarmorstands.api.menu.MenuClick;
import me.m56738.easyarmorstands.color.ColorAxis;
import me.m56738.easyarmorstands.color.ColorAxisSlot;
import me.m56738.easyarmorstands.item.SimpleItemTemplate;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Color;
import org.jetbrains.annotations.NotNull;

public class ColorAxisChangeSlot
extends ColorAxisSlot {
    private final ColorPickerContext context;
    private final ColorAxis axis;
    private final int leftChange;
    private final int rightChange;
    private final int shiftChange;

    public ColorAxisChangeSlot(ColorPickerContext context, ColorAxis axis, SimpleItemTemplate itemTemplate, TagResolver resolver, int leftChange, int rightChange, int shiftChange) {
        super(context, axis, itemTemplate, resolver);
        this.context = context;
        this.axis = axis;
        this.leftChange = leftChange;
        this.rightChange = rightChange;
        this.shiftChange = shiftChange;
    }

    @Override
    public void onClick(@NotNull MenuClick click) {
        int change;
        if (click.isShiftClick()) {
            change = this.shiftChange;
        } else if (click.isRightClick()) {
            change = this.rightChange;
        } else if (click.isLeftClick()) {
            change = this.leftChange;
        } else {
            return;
        }
        Color color = this.context.getColor();
        int value = this.axis.get(color);
        int newValue = Math.max(0, Math.min(255, value + change));
        Color newColor = this.axis.set(color, newValue);
        this.context.setColor(newColor);
    }
}

