/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.capability.egg.v1_20_2;

import java.lang.reflect.Field;
import me.m56738.easyarmorstands.capability.CapabilityProvider;
import me.m56738.easyarmorstands.capability.Priority;
import me.m56738.easyarmorstands.capability.egg.SpawnEggCapability;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntitySnapshot;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SpawnEggMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class SpawnEggCapabilityProvider
implements CapabilityProvider<SpawnEggCapability> {
    @Override
    public boolean isSupported() {
        try {
            Entity.class.getMethod("createSnapshot", new Class[0]);
            SpawnEggMeta.class.getMethod("setSpawnedEntity", EntitySnapshot.class);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    @Override
    public Priority getPriority() {
        return Priority.NORMAL;
    }

    @Override
    public SpawnEggCapability create(Plugin plugin) {
        return new SpawnEggCapabilityImpl();
    }

    private static class SpawnEggCapabilityImpl
    implements SpawnEggCapability {
        private SpawnEggCapabilityImpl() {
        }

        @Override
        public ItemStack createSpawnEgg(Entity entity) {
            Material material;
            EntitySnapshot snapshot = entity.createSnapshot();
            if (snapshot == null) {
                return null;
            }
            try {
                ItemStack item = this.createArmorStand(snapshot);
                if (item != null) {
                    return item;
                }
            }
            catch (Throwable item) {
                // empty catch block
            }
            try {
                material = Material.valueOf((String)(entity.getType().name() + "_SPAWN_EGG"));
            }
            catch (IllegalArgumentException e) {
                return null;
            }
            ItemStack item = new ItemStack(material);
            ItemMeta meta = item.getItemMeta();
            if (!(meta instanceof SpawnEggMeta)) {
                return null;
            }
            ((SpawnEggMeta)meta).setSpawnedEntity(snapshot);
            item.setItemMeta(meta);
            return item;
        }

        @Nullable
        private ItemStack createArmorStand(EntitySnapshot snapshot) throws ReflectiveOperationException {
            if (snapshot.getEntityType() != EntityType.ARMOR_STAND) {
                return null;
            }
            Object data = snapshot.getClass().getMethod("getData", new Class[0]).invoke((Object)snapshot, new Object[0]);
            ItemStack item = new ItemStack(Material.ARMOR_STAND);
            ItemMeta meta = item.getItemMeta();
            if (meta == null) {
                return null;
            }
            Field tagField = meta.getClass().getDeclaredField("entityTag");
            tagField.setAccessible(true);
            tagField.set(meta, data);
            item.setItemMeta(meta);
            return item;
        }
    }
}

