/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.capability.component.v1_8;

import java.util.ArrayList;
import java.util.List;
import me.m56738.easyarmorstands.capability.CapabilityProvider;
import me.m56738.easyarmorstands.capability.Priority;
import me.m56738.easyarmorstands.capability.component.ComponentCapability;
import me.m56738.easyarmorstands.lib.kyori.adventure.platform.bukkit.BukkitComponentSerializer;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.TextComponent;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.format.NamedTextColor;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.format.Style;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.format.TextDecoration;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentCapabilityProvider
implements CapabilityProvider<ComponentCapability> {
    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public Priority getPriority() {
        return Priority.FALLBACK;
    }

    @Override
    public ComponentCapability create(Plugin plugin) {
        return new ComponentCapabilityImpl();
    }

    private static class ComponentCapabilityImpl
    implements ComponentCapability {
        private static final Style fallbackStyle = Style.style(NamedTextColor.WHITE, TextDecoration.ITALIC.withState(false));
        private final LegacyComponentSerializer serializer = BukkitComponentSerializer.legacy();

        private ComponentCapabilityImpl() {
        }

        private static Component style(Component component) {
            if (component == null) {
                return null;
            }
            return component.applyFallbackStyle(fallbackStyle);
        }

        @Override
        @Nullable
        public Component getCustomName(@NotNull Entity entity) {
            return this.serializer.deserializeOrNull(entity.getCustomName());
        }

        @Override
        public void setCustomName(@NotNull Entity entity, @Nullable Component name) {
            entity.setCustomName((String)this.serializer.serializeOrNull(name));
        }

        @Override
        public void setDisplayName(@NotNull ItemMeta meta, @Nullable Component displayName) {
            if (displayName instanceof TextComponent && ((TextComponent)displayName).content().isEmpty()) {
                meta.setDisplayName(ChatColor.RESET.toString());
                return;
            }
            meta.setDisplayName((String)this.serializer.serializeOrNull(ComponentCapabilityImpl.style(displayName)));
        }

        @Override
        public void setLore(@NotNull ItemMeta meta, @NotNull @NotNull List<@NotNull Component> lore) {
            ArrayList<String> legacyLore = new ArrayList<String>(lore.size());
            for (Component component : lore) {
                legacyLore.add(this.serializer.serialize(ComponentCapabilityImpl.style(component)));
            }
            meta.setLore(legacyLore);
        }

        @Override
        @NotNull
        public Component getItemDisplayName(@NotNull ItemStack item) {
            return Component.text(item.getType().name());
        }

        @Override
        @NotNull
        public Inventory createInventory(InventoryHolder holder, int size, Component title) {
            return Bukkit.createInventory((InventoryHolder)holder, (int)size, (String)this.serializer.serialize(title));
        }
    }
}

