/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.api.property.type;

import java.util.EnumMap;
import java.util.Objects;
import java.util.function.Function;
import me.m56738.easyarmorstands.api.property.type.KeyedPropertyType;
import me.m56738.easyarmorstands.api.property.type.PropertyType;
import org.jetbrains.annotations.NotNull;

public final class EnumKeyedPropertyType<K extends Enum<K>, V>
implements KeyedPropertyType<K, V> {
    private final EnumMap<K, PropertyType<V>> map;

    public EnumKeyedPropertyType(Class<K> type, Function<K, PropertyType<V>> provider) {
        this.map = new EnumMap(type);
        for (Enum key : (Enum[])type.getEnumConstants()) {
            this.map.put(key, Objects.requireNonNull(provider.apply(key), "Property type for key: " + key));
        }
    }

    @Override
    @NotNull
    public PropertyType<V> get(@NotNull K key) {
        return Objects.requireNonNull(this.map.get(key));
    }
}

