/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.api.property;

import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Consumer;
import me.m56738.easyarmorstands.api.property.Property;
import me.m56738.easyarmorstands.api.property.PropertyContainer;
import me.m56738.easyarmorstands.api.property.type.PropertyType;
import me.m56738.easyarmorstands.lib.kyori.adventure.key.Keyed;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PropertyMap
implements PropertyContainer {
    private final Map<PropertyType, PropertyImpl> properties = new TreeMap<PropertyType, PropertyImpl>(Comparator.comparing(Keyed::key));

    public PropertyMap() {
    }

    public PropertyMap(@NotNull PropertyContainer container) {
        this.putAll(container);
    }

    public void putAll(@NotNull PropertyContainer container) {
        container.forEach(this::importProperty);
    }

    private <T> void importProperty(@NotNull Property<T> property) {
        this.put(property.getType(), property.getValue());
    }

    @Override
    public void forEach(@NotNull @NotNull Consumer<@NotNull Property<?>> consumer) {
        for (PropertyImpl property : this.properties.values()) {
            consumer.accept(property);
        }
    }

    @Override
    @Nullable
    public <T> Property<T> getOrNull(@NotNull PropertyType<T> type) {
        return this.properties.get(type);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void commit(@Nullable Component description) {
    }

    public <T> boolean put(@NotNull PropertyType<T> type, @NotNull T value) {
        return this.properties.computeIfAbsent(type, x$0 -> new PropertyImpl((PropertyType)x$0)).setValue(value);
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public void remove(PropertyType<?> type) {
        this.properties.remove(type);
    }

    public void clear() {
        this.properties.clear();
    }

    private static class PropertyImpl<T>
    implements Property<T> {
        private final PropertyType<T> type;
        private T value;

        private PropertyImpl(PropertyType<T> type) {
            this.type = type;
        }

        @Override
        @NotNull
        public PropertyType<T> getType() {
            return this.type;
        }

        @Override
        @NotNull
        public T getValue() {
            return this.type.cloneValue(this.value);
        }

        @Override
        public boolean setValue(@NotNull T value) {
            Objects.requireNonNull(value);
            this.value = this.type.cloneValue(value);
            return true;
        }
    }
}

