/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.api.property;

import java.util.function.Consumer;
import me.m56738.easyarmorstands.api.property.ImmutablePropertyContainer;
import me.m56738.easyarmorstands.api.property.Property;
import me.m56738.easyarmorstands.api.property.UnknownPropertyException;
import me.m56738.easyarmorstands.api.property.type.PropertyType;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PropertyContainer {
    @Contract(pure=true)
    @NotNull
    public static PropertyContainer immutable(@NotNull PropertyContainer container) {
        if (container instanceof ImmutablePropertyContainer) {
            return container;
        }
        return new ImmutablePropertyContainer(container);
    }

    public void forEach(@NotNull @NotNull Consumer<@NotNull Property<?>> var1);

    @Contract(pure=true)
    @Nullable
    public <T> Property<T> getOrNull(@NotNull PropertyType<T> var1);

    @Contract(pure=true)
    @NotNull
    default public <T> Property<T> get(@NotNull PropertyType<T> type) {
        Property<T> property = this.getOrNull(type);
        if (property == null) {
            throw new UnknownPropertyException(type);
        }
        return property;
    }

    @Contract(pure=true)
    public boolean isValid();

    public void commit(@Nullable Component var1);

    default public void commit() {
        this.commit(null);
    }
}

