/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.api;

import java.util.function.BiConsumer;
import java.util.function.Function;
import org.bukkit.entity.ArmorStand;
import org.bukkit.util.EulerAngle;
import org.jetbrains.annotations.NotNull;

public enum ArmorStandPart {
    HEAD(ArmorStand::getHeadPose, ArmorStand::setHeadPose),
    BODY(ArmorStand::getBodyPose, ArmorStand::setBodyPose),
    LEFT_ARM(ArmorStand::getLeftArmPose, ArmorStand::setLeftArmPose),
    RIGHT_ARM(ArmorStand::getRightArmPose, ArmorStand::setRightArmPose),
    LEFT_LEG(ArmorStand::getLeftLegPose, ArmorStand::setLeftLegPose),
    RIGHT_LEG(ArmorStand::getRightLegPose, ArmorStand::setRightLegPose);

    private final Function<ArmorStand, EulerAngle> poseGetter;
    private final BiConsumer<ArmorStand, EulerAngle> poseSetter;

    private ArmorStandPart(Function<ArmorStand, EulerAngle> poseGetter, BiConsumer<ArmorStand, EulerAngle> poseSetter) {
        this.poseGetter = poseGetter;
        this.poseSetter = poseSetter;
    }

    @NotNull
    public EulerAngle getPose(@NotNull ArmorStand armorStand) {
        return this.poseGetter.apply(armorStand);
    }

    public void setPose(@NotNull ArmorStand armorStand, @NotNull EulerAngle pose) {
        this.poseSetter.accept(armorStand, pose);
    }
}

