/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.util;

import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import me.m56738.easyarmorstands.api.ArmorStandPart;
import me.m56738.easyarmorstands.api.ArmorStandSize;
import me.m56738.easyarmorstands.lib.joml.Vector3d;
import me.m56738.easyarmorstands.lib.joml.Vector3dc;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import me.m56738.easyarmorstands.message.Message;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ArmorStandPartInfo {
    private static final Map<ArmorStandPart, ArmorStandPartInfo> parts = new EnumMap<ArmorStandPart, ArmorStandPartInfo>(ArmorStandPart.class);
    private final String name;
    private final Component displayName;
    private final Vector3dc offset;
    private final Vector3dc length;
    private final Vector3dc smallOffset;
    private final Vector3dc smallLength;

    private ArmorStandPartInfo(String name, Component displayName, Vector3dc offset, Vector3dc length) {
        this.name = name;
        this.displayName = displayName;
        this.offset = offset.div(16.0, new Vector3d());
        this.length = length.div(16.0, new Vector3d());
        this.smallOffset = this.offset.div(2.0, new Vector3d());
        this.smallLength = this.length.div(2.0, new Vector3d());
    }

    @Contract(pure=true)
    @NotNull
    public static ArmorStandPartInfo of(ArmorStandPart part) {
        return Objects.requireNonNull(parts.get((Object)part));
    }

    public String getName() {
        return this.name;
    }

    public Component getDisplayName() {
        return this.displayName;
    }

    public Vector3dc getOffset(ArmorStandSize size, double scale) {
        Vector3dc offset = size.isSmall() ? this.smallOffset : this.offset;
        return this.mul(offset, scale);
    }

    public Vector3dc getLength(ArmorStandSize size, double scale) {
        Vector3dc length = size.isSmall() ? this.smallLength : this.length;
        return this.mul(length, scale);
    }

    private Vector3dc mul(Vector3dc vector, double scale) {
        if (scale == 1.0) {
            return vector;
        }
        return vector.mul(scale, new Vector3d());
    }

    static {
        parts.put(ArmorStandPart.HEAD, new ArmorStandPartInfo("head", Message.component("easyarmorstands.armor-stand-part.head"), new Vector3d(0.0, 23.0, 0.0), new Vector3d(0.0, 7.0, 0.0)));
        parts.put(ArmorStandPart.BODY, new ArmorStandPartInfo("body", Message.component("easyarmorstands.armor-stand-part.body"), new Vector3d(0.0, 24.0, 0.0), new Vector3d(0.0, -12.0, 0.0)));
        parts.put(ArmorStandPart.LEFT_ARM, new ArmorStandPartInfo("left-arm", Message.component("easyarmorstands.armor-stand-part.left-arm"), new Vector3d(5.0, 22.0, 0.0), new Vector3d(0.0, -10.0, 0.0)));
        parts.put(ArmorStandPart.RIGHT_ARM, new ArmorStandPartInfo("right-arm", Message.component("easyarmorstands.armor-stand-part.right-arm"), new Vector3d(-5.0, 22.0, 0.0), new Vector3d(0.0, -10.0, 0.0)));
        parts.put(ArmorStandPart.LEFT_LEG, new ArmorStandPartInfo("left-leg", Message.component("easyarmorstands.armor-stand-part.left-leg"), new Vector3d(1.9, 12.0, 0.0), new Vector3d(0.0, -11.0, 0.0)));
        parts.put(ArmorStandPart.RIGHT_LEG, new ArmorStandPartInfo("right-leg", Message.component("easyarmorstands.armor-stand-part.right-leg"), new Vector3d(-1.9, 12.0, 0.0), new Vector3d(0.0, -11.0, 0.0)));
    }
}

