/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.session;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import me.m56738.easyarmorstands.EasyArmorStandsPlugin;
import me.m56738.easyarmorstands.api.editor.EyeRay;
import me.m56738.easyarmorstands.api.editor.Session;
import me.m56738.easyarmorstands.api.editor.button.MenuButtonProvider;
import me.m56738.easyarmorstands.api.editor.context.ClickContext;
import me.m56738.easyarmorstands.api.editor.input.Category;
import me.m56738.easyarmorstands.api.editor.input.Input;
import me.m56738.easyarmorstands.api.editor.node.ElementNode;
import me.m56738.easyarmorstands.api.editor.node.Node;
import me.m56738.easyarmorstands.api.editor.node.NodeProvider;
import me.m56738.easyarmorstands.api.element.Element;
import me.m56738.easyarmorstands.api.particle.Particle;
import me.m56738.easyarmorstands.api.particle.ParticleProvider;
import me.m56738.easyarmorstands.api.property.PropertyContainer;
import me.m56738.easyarmorstands.command.sender.EasPlayer;
import me.m56738.easyarmorstands.config.EasConfig;
import me.m56738.easyarmorstands.config.InputHintsConfig;
import me.m56738.easyarmorstands.context.ChangeContext;
import me.m56738.easyarmorstands.group.GroupMember;
import me.m56738.easyarmorstands.group.node.GroupRootNode;
import me.m56738.easyarmorstands.lib.joml.Math;
import me.m56738.easyarmorstands.lib.joml.Matrix4dc;
import me.m56738.easyarmorstands.lib.joml.Vector2dc;
import me.m56738.easyarmorstands.lib.joml.Vector3d;
import me.m56738.easyarmorstands.lib.joml.Vector3dc;
import me.m56738.easyarmorstands.lib.kyori.adventure.audience.Audience;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.TextComponent;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.format.NamedTextColor;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.format.Style;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.minimessage.MiniMessage;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.minimessage.tag.Tag;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import me.m56738.easyarmorstands.lib.kyori.adventure.title.Title;
import me.m56738.easyarmorstands.lib.kyori.adventure.title.TitlePart;
import me.m56738.easyarmorstands.particle.EditorParticle;
import me.m56738.easyarmorstands.particle.GizmoParticleProvider;
import me.m56738.easyarmorstands.property.TrackedPropertyContainer;
import me.m56738.easyarmorstands.session.EyeRayImpl;
import me.m56738.easyarmorstands.session.MenuButtonProviderImpl;
import me.m56738.easyarmorstands.session.NodeProviderImpl;
import me.m56738.easyarmorstands.session.SessionSnapper;
import me.m56738.easyarmorstands.session.context.AddContextImpl;
import me.m56738.easyarmorstands.session.context.ClickContextImpl;
import me.m56738.easyarmorstands.session.context.EnterContextImpl;
import me.m56738.easyarmorstands.session.context.ExitContextImpl;
import me.m56738.easyarmorstands.session.context.RemoveContextImpl;
import me.m56738.easyarmorstands.session.context.UpdateContextImpl;
import me.m56738.easyarmorstands.util.Util;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public final class SessionImpl
implements Session {
    private static final Title.Times titleTimes = Title.Times.times(Duration.ZERO, Duration.ofSeconds(2L), Duration.ofSeconds(1L));
    private final LinkedList<Node> nodeStack = new LinkedList();
    private final Player player;
    private final Audience audience;
    private final ChangeContext context;
    private final SessionSnapper snapper;
    private final Set<EditorParticle> particles = new HashSet<EditorParticle>();
    private final ParticleProvider particleProvider;
    private final MenuButtonProvider menuButtonProvider = new MenuButtonProviderImpl(this);
    private final NodeProvider nodeProvider = new NodeProviderImpl(this);
    private final List<Input> inputs = new ArrayList<Input>();
    private int clickTicks = 5;
    private boolean valid = true;
    private Component currentTitle = Component.empty();
    private Component currentSubtitle = Component.empty();
    private Component currentActionBar = Component.empty();
    private int overlayTicks;
    private boolean toolRequired;
    private Category inputCategory = Category.PRIMARY;
    private boolean hasSecondaryInputs;

    public SessionImpl(EasPlayer context) {
        this.player = context.get();
        this.audience = context;
        this.context = context;
        this.snapper = new SessionSnapper(this.player);
        this.particleProvider = new GizmoParticleProvider(EasyArmorStandsPlugin.getInstance().getGizmos().player(this.player));
    }

    @Override
    public Node getNode() {
        return this.nodeStack.peek();
    }

    public @UnmodifiableView List<Node> getNodeStack() {
        return Collections.unmodifiableList(this.nodeStack);
    }

    @Override
    @Nullable
    public <T extends Node> T findNode(@NotNull Class<T> type) {
        for (Node node : this.nodeStack) {
            if (!type.isAssignableFrom(node.getClass())) continue;
            return (T)node;
        }
        return null;
    }

    @Override
    public double getScale(Vector3dc position) {
        EasConfig config = EasyArmorStandsPlugin.getInstance().getConfiguration();
        Vector3d eyePosition = Util.toVector3d(this.player.getEyeLocation());
        double maxDistance = config.editor.scale.maxDistance;
        double minDistance = config.editor.scale.minDistance;
        if (maxDistance <= minDistance) {
            return 1.0;
        }
        double distance = Math.clamp(minDistance, maxDistance, eyePosition.distance(position));
        return distance / minDistance;
    }

    @Override
    public void pushNode(@NotNull Node node) {
        this.pushNode(node, null);
    }

    @Override
    public void pushNode(@NotNull Node node, @Nullable Vector3dc cursor) {
        if (!this.valid) {
            return;
        }
        if (!this.nodeStack.isEmpty()) {
            this.nodeStack.peek().onExit(ExitContextImpl.INSTANCE);
        }
        this.nodeStack.push(node);
        node.onAdd(AddContextImpl.INSTANCE);
        node.onEnter(new EnterContextImpl(this, cursor));
    }

    @Override
    public void popNode() {
        if (!this.valid) {
            return;
        }
        Node removed = this.nodeStack.pop();
        removed.onExit(ExitContextImpl.INSTANCE);
        removed.onRemove(RemoveContextImpl.INSTANCE);
        if (!this.nodeStack.isEmpty()) {
            this.nodeStack.peek().onEnter(new EnterContextImpl(this, null));
        }
    }

    @Override
    public void returnToNode(@NotNull Node target) {
        int count = this.nodeStack.indexOf(target);
        for (int i = 0; i < count; ++i) {
            this.popNode();
        }
    }

    @Override
    public void clearNodes() {
        if (!this.valid) {
            return;
        }
        if (!this.nodeStack.isEmpty()) {
            this.nodeStack.peek().onExit(ExitContextImpl.INSTANCE);
        }
        for (Node node : this.nodeStack) {
            node.onRemove(RemoveContextImpl.INSTANCE);
        }
        this.nodeStack.clear();
    }

    private boolean hasClickCooldown(ClickContext.Type type) {
        return type != ClickContext.Type.SWAP_HANDS;
    }

    public boolean handleClick(ClickContextImpl context) {
        if (!this.valid) {
            return false;
        }
        Node node = this.nodeStack.peek();
        if (node == null) {
            return false;
        }
        if (this.hasClickCooldown(context.type())) {
            if (this.clickTicks > 0) {
                return false;
            }
            this.clickTicks = 5;
        }
        if (node.onClick(context)) {
            return true;
        }
        for (Input input : this.inputs) {
            if (input.category() != this.inputCategory || input.clickType() != context.type()) continue;
            input.execute(context);
            return true;
        }
        return false;
    }

    @Override
    public Element getElement() {
        for (Node node : this.nodeStack) {
            if (!(node instanceof ElementNode)) continue;
            return ((ElementNode)node).getElement();
        }
        return null;
    }

    @NotNull
    public List<Element> getElements() {
        for (Node node : this.nodeStack) {
            if (node instanceof ElementNode) {
                return Collections.singletonList(((ElementNode)node).getElement());
            }
            if (!(node instanceof GroupRootNode)) continue;
            return ((GroupRootNode)node).getGroup().getMembers().stream().map(GroupMember::getElement).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    boolean update() {
        if (this.clickTicks > 0) {
            --this.clickTicks;
        }
        while (!this.nodeStack.isEmpty() && !this.nodeStack.peek().isValid()) {
            this.popNode();
        }
        UpdateContextImpl context = new UpdateContextImpl(this);
        Node currentNode = this.nodeStack.peek();
        if (currentNode != null) {
            currentNode.onUpdate(context);
        }
        for (Node node : this.nodeStack) {
            if (node == currentNode) continue;
            node.onInactiveUpdate(context);
        }
        for (EditorParticle particle : this.particles) {
            particle.updateGizmo();
        }
        this.inputs.clear();
        this.inputs.addAll(context.getInputs());
        this.hasSecondaryInputs = false;
        for (Input input : this.inputs) {
            if (input.category() != Category.SECONDARY) continue;
            this.hasSecondaryInputs = true;
            break;
        }
        this.inputCategory = Category.PRIMARY;
        if (this.player.isSneaking() && this.hasSecondaryInputs) {
            this.inputCategory = Category.SECONDARY;
        }
        this.updateOverlay(context);
        return this.player.isValid();
    }

    private void updateOverlay(UpdateContextImpl context) {
        boolean resendOverlay;
        Component pendingActionBar = this.createActionBar(context.getActionBar());
        Component pendingTitle = context.getTitle();
        Component pendingSubtitle = context.getSubtitle();
        boolean bl = resendOverlay = this.overlayTicks <= 0;
        if (resendOverlay) {
            this.overlayTicks = 20;
            this.audience.sendTitlePart(TitlePart.TIMES, titleTimes);
        }
        --this.overlayTicks;
        if (resendOverlay || !Objects.equals(this.currentTitle, pendingTitle) || !Objects.equals(this.currentSubtitle, pendingSubtitle)) {
            this.currentTitle = pendingTitle;
            this.currentSubtitle = pendingSubtitle;
            this.audience.sendTitlePart(TitlePart.SUBTITLE, this.currentSubtitle);
            this.audience.sendTitlePart(TitlePart.TITLE, this.currentTitle);
        }
        if (resendOverlay || !Objects.equals(this.currentActionBar, pendingActionBar)) {
            this.currentActionBar = pendingActionBar;
            this.audience.sendActionBar(this.currentActionBar);
        }
    }

    private Component createActionBar(Component value) {
        InputHintsConfig config = EasyArmorStandsPlugin.getInstance().getConfiguration().editor.inputHints;
        if (!config.enabled) {
            return value;
        }
        TextComponent.Builder builder = Component.text();
        builder.append(value);
        EnumSet<ClickContext.Type> seen = EnumSet.noneOf(ClickContext.Type.class);
        for (Input input : this.inputs) {
            ClickContext.Type clickType;
            if (input.category() != this.inputCategory || !seen.add(clickType = input.clickType())) continue;
            builder.append(this.createInput(config, this.getKey(config, clickType), input.name(), input.style()));
        }
        if (this.inputCategory == Category.PRIMARY && this.hasSecondaryInputs) {
            builder.append(this.createInput(config, config.sneakKey, Component.translatable("easyarmorstands.input.more"), Style.style(NamedTextColor.GRAY)));
        }
        return builder.build();
    }

    private Component createInput(InputHintsConfig config, Component key, Component input, Style style) {
        TagResolver resolver = TagResolver.builder().tag("key", Tag.selfClosingInserting(key)).tag("input", Tag.selfClosingInserting(input)).build();
        return MiniMessage.miniMessage().deserialize(config.format, resolver).applyFallbackStyle(style);
    }

    private Component getKey(InputHintsConfig config, ClickContext.Type type) {
        if (type == ClickContext.Type.LEFT_CLICK) {
            return config.leftClickKey;
        }
        if (type == ClickContext.Type.RIGHT_CLICK) {
            return config.rightClickKey;
        }
        if (type == ClickContext.Type.SWAP_HANDS) {
            return config.swapHandsKey;
        }
        return Component.empty();
    }

    void stop() {
        Node currentNode = this.nodeStack.peek();
        if (currentNode != null) {
            currentNode.onExit(ExitContextImpl.INSTANCE);
        }
        for (Node node : this.nodeStack) {
            node.onRemove(RemoveContextImpl.INSTANCE);
        }
        this.nodeStack.clear();
        this.audience.clearTitle();
        this.audience.sendActionBar(Component.empty());
        for (EditorParticle particle : this.particles) {
            particle.hideGizmo();
        }
        this.particles.clear();
        this.valid = false;
    }

    public ChangeContext context() {
        return this.context;
    }

    public double getRange() {
        return EasyArmorStandsPlugin.getInstance().getConfiguration().editor.button.range;
    }

    public double getLookThreshold() {
        return EasyArmorStandsPlugin.getInstance().getConfiguration().editor.button.threshold;
    }

    @Override
    public void addParticle(@NotNull Particle particle) {
        if (!this.valid) {
            return;
        }
        EditorParticle editorParticle = (EditorParticle)particle;
        if (this.particles.add(editorParticle)) {
            editorParticle.showGizmo();
        }
    }

    @Override
    public void removeParticle(@NotNull Particle particle) {
        if (!this.valid) {
            return;
        }
        EditorParticle editorParticle = (EditorParticle)particle;
        if (this.particles.remove(editorParticle)) {
            editorParticle.hideGizmo();
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    @Override
    @NotNull
    public Player player() {
        return this.player;
    }

    @Override
    @NotNull
    public PropertyContainer properties(@NotNull Element element) {
        return new TrackedPropertyContainer(element, this.context);
    }

    @Override
    @NotNull
    public EyeRay eyeRay() {
        double length = this.getRange();
        Location eyeLocation = this.player.getEyeLocation();
        double threshold = this.getLookThreshold();
        return new EyeRayImpl(eyeLocation.getWorld(), eyeLocation, length, threshold);
    }

    @NotNull
    public EyeRay eyeRay(Vector2dc cursor) {
        double length = this.getRange();
        Location eyeLocation = this.player.getEyeLocation();
        Matrix4dc eyeMatrix = this.eyeMatrix(eyeLocation);
        Vector3d origin = eyeMatrix.transformPosition(cursor.x(), cursor.y(), 0.0, new Vector3d());
        eyeLocation.setX(origin.x);
        eyeLocation.setY(origin.y);
        eyeLocation.setZ(origin.z);
        double threshold = this.getLookThreshold();
        return new EyeRayImpl(eyeLocation.getWorld(), eyeLocation, length, threshold);
    }

    private Matrix4dc eyeMatrix(Location eyeLocation) {
        return Util.toMatrix4d(eyeLocation);
    }

    @Override
    @NotNull
    public ParticleProvider particleProvider() {
        return this.particleProvider;
    }

    @Override
    @NotNull
    public MenuButtonProvider menuEntryProvider() {
        return this.menuButtonProvider;
    }

    @Override
    @NotNull
    public NodeProvider nodeProvider() {
        return this.nodeProvider;
    }

    @Override
    @NotNull
    public SessionSnapper snapper() {
        return this.snapper;
    }

    public boolean isToolRequired() {
        return this.toolRequired;
    }

    public void setToolRequired(boolean toolRequired) {
        this.toolRequired = toolRequired;
    }
}

