/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.region;

import java.util.HashMap;
import java.util.Map;
import me.m56738.easyarmorstands.api.region.RegionPrivilegeChecker;
import me.m56738.easyarmorstands.api.region.RegionPrivilegeManager;
import me.m56738.easyarmorstands.region.RegionListener;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class RegionListenerManager
implements RegionPrivilegeManager {
    private final Map<RegionPrivilegeChecker, RegionListener> regionListeners = new HashMap<RegionPrivilegeChecker, RegionListener>();

    @Override
    public void registerPrivilegeChecker(@NotNull Plugin plugin, @NotNull RegionPrivilegeChecker privilegeChecker) {
        RegionListener listener = new RegionListener(privilegeChecker);
        plugin.getServer().getPluginManager().registerEvents((Listener)listener, plugin);
        RegionListener old = this.regionListeners.put(privilegeChecker, listener);
        if (old != null) {
            HandlerList.unregisterAll((Listener)old);
        }
    }

    @Override
    public void unregisterPrivilegeChecker(@NotNull RegionPrivilegeChecker privilegeChecker) {
        RegionListener listener = this.regionListeners.remove(privilegeChecker);
        if (listener != null) {
            HandlerList.unregisterAll((Listener)listener);
        }
    }

    public void unregisterAll() {
        for (RegionListener listener : this.regionListeners.values()) {
            HandlerList.unregisterAll((Listener)listener);
        }
        this.regionListeners.clear();
    }
}

