/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.region;

import java.util.Map;
import java.util.WeakHashMap;
import me.m56738.easyarmorstands.api.element.Element;
import me.m56738.easyarmorstands.api.element.EntityElement;
import me.m56738.easyarmorstands.api.event.player.PlayerCreateElementEvent;
import me.m56738.easyarmorstands.api.event.player.PlayerDestroyElementEvent;
import me.m56738.easyarmorstands.api.event.player.PlayerDiscoverElementEvent;
import me.m56738.easyarmorstands.api.event.player.PlayerEditElementEvent;
import me.m56738.easyarmorstands.api.event.player.PlayerEditPropertyEvent;
import me.m56738.easyarmorstands.api.event.session.SessionStartEvent;
import me.m56738.easyarmorstands.api.property.type.EntityPropertyTypes;
import me.m56738.easyarmorstands.api.region.RegionPrivilegeChecker;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class RegionListener
implements Listener {
    private final Map<Player, Boolean> bypassCache = new WeakHashMap<Player, Boolean>();
    private final RegionPrivilegeChecker privilegeChecker;

    public RegionListener(RegionPrivilegeChecker privilegeChecker) {
        this.privilegeChecker = privilegeChecker;
    }

    private boolean isAllowed(Player player, Location location, boolean silent) {
        return this.privilegeChecker.isAllowed(player, location, silent);
    }

    @EventHandler
    public void onInitialize(SessionStartEvent event) {
        this.bypassCache.remove(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onDiscover(PlayerDiscoverElementEvent event) {
        if (this.canBypass(event.getPlayer())) {
            return;
        }
        if (this.isAllowed(event.getPlayer(), event.getElement().getProperties().get(EntityPropertyTypes.LOCATION).getValue(), true)) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEdit(PlayerEditElementEvent event) {
        if (this.canBypass(event.getPlayer())) {
            return;
        }
        if (this.isAllowed(event.getPlayer(), event.getElement().getProperties().get(EntityPropertyTypes.LOCATION).getValue(), false)) {
            return;
        }
        event.setCancelled(true);
        this.privilegeChecker.sendEditError(event.getPlayer(), event.getElement());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onSpawn(PlayerCreateElementEvent event) {
        if (this.canBypass(event.getPlayer())) {
            return;
        }
        if (this.isAllowed(event.getPlayer(), event.getProperties().get(EntityPropertyTypes.LOCATION).getValue(), false)) {
            return;
        }
        event.setCancelled(true);
        this.privilegeChecker.sendCreateError(event.getPlayer(), event.getProperties());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEdit(PlayerEditPropertyEvent<?> event) {
        Element element = event.getElement();
        if (!(element instanceof EntityElement)) {
            return;
        }
        if (this.bypassCache.computeIfAbsent(event.getPlayer(), this::canBypass).booleanValue()) {
            return;
        }
        Object entity = ((EntityElement)element).getEntity();
        if (this.isAllowed(event.getPlayer(), entity.getLocation(), true)) {
            if (event.getProperty().getType() != EntityPropertyTypes.LOCATION) {
                return;
            }
            if (this.isAllowed(event.getPlayer(), (Location)event.getNewValue(), true)) {
                return;
            }
        }
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onDestroy(PlayerDestroyElementEvent event) {
        if (this.bypassCache.computeIfAbsent(event.getPlayer(), this::canBypass).booleanValue()) {
            return;
        }
        if (this.isAllowed(event.getPlayer(), event.getElement().getProperties().get(EntityPropertyTypes.LOCATION).getValue(), false)) {
            return;
        }
        event.setCancelled(true);
        this.privilegeChecker.sendDestroyError(event.getPlayer(), event.getElement());
    }

    private boolean canBypass(Player player) {
        boolean bypass = this.privilegeChecker.canBypass(player);
        this.bypassCache.put(player, bypass);
        return bypass;
    }
}

