/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.property;

import java.util.Objects;
import me.m56738.easyarmorstands.api.element.Element;
import me.m56738.easyarmorstands.api.property.PendingChange;
import me.m56738.easyarmorstands.api.property.Property;
import me.m56738.easyarmorstands.history.ChangeTracker;

class TrackedPendingChangeWrapper<T>
implements PendingChange {
    private final ChangeTracker tracker;
    private final Element element;
    private final Property<T> property;
    private final T value;
    private final PendingChange pendingChange;

    TrackedPendingChangeWrapper(ChangeTracker tracker, Element element, Property<T> property, T value, PendingChange pendingChange) {
        this.tracker = tracker;
        this.element = element;
        this.property = property;
        this.value = value;
        this.pendingChange = pendingChange;
    }

    @Override
    public boolean execute() {
        T oldValue = this.property.getValue();
        if (Objects.equals(oldValue, this.value)) {
            return true;
        }
        if (!this.pendingChange.execute()) {
            return false;
        }
        this.tracker.recordChange(this.element, this.property, oldValue, this.value);
        return true;
    }
}

