/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.property;

import me.m56738.easyarmorstands.api.element.Element;
import me.m56738.easyarmorstands.api.property.PendingChange;
import me.m56738.easyarmorstands.api.property.Property;
import me.m56738.easyarmorstands.api.property.type.PropertyType;
import me.m56738.easyarmorstands.context.ChangeContext;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PermissionCheckedPropertyWrapper<T>
implements Property<T> {
    private final Property<T> property;
    private final Element element;
    private final ChangeContext context;
    private Boolean hasPermissionCache;

    PermissionCheckedPropertyWrapper(Property<T> property, Element element, ChangeContext context) {
        this.property = property;
        this.element = element;
        this.context = context;
    }

    private boolean hasPermission() {
        if (this.hasPermissionCache != null) {
            return this.hasPermissionCache;
        }
        boolean result = this.property.getType().canChange(this.context.player());
        this.hasPermissionCache = result;
        return result;
    }

    @Override
    @NotNull
    public PropertyType<T> getType() {
        return this.property.getType();
    }

    @Override
    @NotNull
    public T getValue() {
        return this.property.getValue();
    }

    private boolean isAllowed(T value) {
        if (!this.hasPermission()) {
            return false;
        }
        return this.context.canChangeProperty(this.element, this.property, value);
    }

    @Override
    public boolean setValue(@NotNull T value) {
        if (!this.isAllowed(value)) {
            return false;
        }
        return this.property.setValue(value);
    }

    @Override
    @Nullable
    public PendingChange prepareChange(@NotNull T value) {
        if (!this.isAllowed(value)) {
            return null;
        }
        return this.property.prepareChange(value);
    }

    @Override
    public boolean canChange(@NotNull Player player) {
        return this.hasPermission();
    }
}

