/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.permission;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import me.m56738.easyarmorstands.permission.Child;
import me.m56738.easyarmorstands.permission.Children;
import me.m56738.easyarmorstands.permission.Description;
import org.bukkit.Bukkit;
import org.bukkit.entity.EntityType;
import org.bukkit.permissions.Permission;

public class Permissions {
    @Description(value="Allow aligning entities to the block grid")
    public static final String ALIGN = "easyarmorstands.align";
    @Description(value="Allow bypassing BentoBox restrictions")
    public static final String BENTOBOX_BYPASS = "easyarmorstands.bentobox.bypass";
    @Description(value="Allow copying properties")
    public static final String CLIPBOARD = "easyarmorstands.clipboard";
    @Description(value="Allow cloning entities")
    public static final String CLONE = "easyarmorstands.clone";
    @Description(value="Allow using the color picker")
    public static final String COLOR = "easyarmorstands.color";
    @Description(value="Allow converting armor stands to item displays")
    public static final String CONVERT = "easyarmorstands.convert";
    @Description(value="Allow copying entities as items (armor stands or spawn eggs)")
    public static final String COPY_ENTITY = "easyarmorstands.copy.entity";
    @Description(value="Allow viewing troubleshooting information")
    public static final String DEBUG = "easyarmorstands.debug";
    @Description(value="Allow destroying entities")
    public static final String DESTROY = "easyarmorstands.destroy";
    @Description(value="Allow destroying FancyHolograms holograms")
    public static final String FANCYHOLOGRAMS_DESTROY = "easyarmorstands.fancyholograms.destroy";
    @Description(value="Allow editing FancyHolograms holograms")
    public static final String FANCYHOLOGRAMS_EDIT = "easyarmorstands.fancyholograms.edit";
    @Description(value="Allow spawning FancyHolograms holograms")
    public static final String FANCYHOLOGRAMS_SPAWN = "easyarmorstands.fancyholograms.spawn";
    @Description(value="Allow spawning the tool item")
    public static final String GIVE = "easyarmorstands.give";
    @Description(value="Allow bypassing GriefDefender restrictions")
    public static final String GRIEFDEFENDER_BYPASS = "easyarmorstands.griefdefender.bypass";
    @Description(value="Allow bypassing GriefPrevention restrictions")
    public static final String GRIEFPREVENTION_BYPASS = "easyarmorstands.griefprevention.bypass";
    @Description(value="Allow editing groups of entities")
    public static final String GROUP = "easyarmorstands.group";
    @Description(value="Allow using the help command")
    public static final String HELP = "easyarmorstands.help";
    @Description(value="Allow showing the history")
    public static final String HISTORY = "easyarmorstands.history";
    @Description(value="Allow bypassing HuskClaims restrictions")
    public static final String HUSKCLAIMS_BYPASS = "easyarmorstands.huskclaims.bypass";
    @Description(value="Allow viewing details of the selected entity")
    public static final String INFO = "easyarmorstands.info";
    @Description(value="Allow bypassing Lands restrictions")
    public static final String LANDS_BYPASS = "easyarmorstands.lands.bypass";
    @Description(value="Allow opening the menu")
    public static final String OPEN = "easyarmorstands.open";
    @Description(value="Allow teleporting entities")
    public static final String POSITION = "easyarmorstands.position";
    @Description(value="Allow bypassing PlotSquared restrictions")
    public static final String PLOTSQUARED_BYPASS = "easyarmorstands.plotsquared.bypass";
    @Description(value="Allow redoing changes")
    public static final String REDO = "easyarmorstands.redo";
    @Description(value="Allow reloading the configuration")
    public static final String RELOAD = "easyarmorstands.reload";
    @Description(value="Allow bypassing Residence restrictions")
    public static final String RESIDENCE_BYPASS = "easyarmorstands.residence.bypass";
    @Description(value="Allow configuring the snapping increment")
    public static final String SNAP = "easyarmorstands.snap";
    @Description(value="Allow selecting matching entities using a selector")
    public static final String SELECT = "easyarmorstands.select";
    @Description(value="Allow selecting entities with a certain tag")
    public static final String SELECT_TAG = "easyarmorstands.select.tag";
    @Description(value="Allow spawning entities")
    public static final String SPAWN = "easyarmorstands.spawn";
    @Description(value="Allow bypassing Towny restrictions")
    public static final String TOWNY_BYPASS = "easyarmorstands.towny.bypass";
    @Description(value="Allow using the TrainCarts resource pack model browser")
    public static final String TRAINCARTS_MODEL = "easyarmorstands.traincarts.model";
    @Description(value="Allow undoing changes")
    public static final String UNDO = "easyarmorstands.undo";
    @Description(value="Be notified when a new version of EasyArmorStands is available")
    public static final String UPDATE_NOTIFY = "easyarmorstands.update.notify";
    @Description(value="Allow viewing the plugin version")
    public static final String VERSION = "easyarmorstands.version";
    @Description(value="Allow bypassing WorldGuard restrictions")
    public static final String WORLDGUARD_BYPASS = "easyarmorstands.worldguard.bypass";
    @Description(value="Allow using the editor")
    @Children(value={@Child(value="easyarmorstands.group"), @Child(value="easyarmorstands.help"), @Child(value="easyarmorstands.history"), @Child(value="easyarmorstands.info"), @Child(value="easyarmorstands.open"), @Child(value="easyarmorstands.version")})
    public static final String EDIT = "easyarmorstands.edit";
    private static final Map<String, Permission> registeredPermissions = new HashMap<String, Permission>();

    private Permissions() {
    }

    public static void registerAll() {
        try {
            for (Field field : Permissions.class.getDeclaredFields()) {
                int modifiers = field.getModifiers();
                if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers)) continue;
                Permissions.register(field);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        for (Field field : EntityType.values()) {
            Permissions.register((EntityType)field, SPAWN, "spawning");
            Permissions.register((EntityType)field, DESTROY, "destroying");
            Permissions.register((EntityType)field, EDIT, "editing");
        }
    }

    public static String entityType(String prefix, EntityType type) {
        return prefix + "." + type.name().toLowerCase(Locale.ROOT).replace("_", "");
    }

    private static void register(EntityType type, String owner, String verb) {
        String name = Permissions.entityType(owner, type);
        HashMap<String, Boolean> children = new HashMap<String, Boolean>(1);
        children.put(owner, true);
        Permissions.register(new Permission(name, "Allow " + verb + " entities of type " + type, children));
    }

    public static Permission register(Permission permission) {
        try {
            Bukkit.getPluginManager().addPermission(permission);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        registeredPermissions.put(permission.getName(), permission);
        return permission;
    }

    public static void unregisterAll() {
        for (Permission permission : registeredPermissions.values()) {
            Bukkit.getPluginManager().removePermission(permission);
        }
        registeredPermissions.clear();
    }

    public static void unregister(Permission permission) {
        registeredPermissions.remove(permission.getName(), permission);
        Bukkit.getPluginManager().removePermission(permission);
    }

    private static void register(Field field) throws ReflectiveOperationException {
        String name = (String)field.get(null);
        Description descriptionAnnotation = field.getDeclaredAnnotation(Description.class);
        String description = descriptionAnnotation != null ? descriptionAnnotation.value() : null;
        Children childrenAnnotation = field.getDeclaredAnnotation(Children.class);
        HashMap<String, Boolean> children = new HashMap<String, Boolean>();
        if (childrenAnnotation != null) {
            for (Child child : childrenAnnotation.value()) {
                children.put(child.value(), true);
            }
        }
        Permissions.register(new Permission(name, description, children));
    }
}

