/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.particle;

import java.util.function.Supplier;
import me.m56738.easyarmorstands.api.Axis;
import me.m56738.easyarmorstands.api.particle.BoundingBoxParticle;
import me.m56738.easyarmorstands.api.particle.ParticleColor;
import me.m56738.easyarmorstands.api.util.BoundingBox;
import me.m56738.easyarmorstands.lib.joml.Vector3d;
import me.m56738.easyarmorstands.lib.joml.Vector3dc;
import me.m56738.easyarmorstands.particle.EditorParticle;
import me.m56738.easyarmorstands.particle.GizmoLineParticle;
import org.jetbrains.annotations.NotNull;

public class LineBoundingBoxParticle
implements BoundingBoxParticle,
EditorParticle {
    private final Line[] lines;
    private BoundingBox box = BoundingBox.of((Vector3dc)new Vector3d());
    private ParticleColor color = ParticleColor.WHITE;

    public LineBoundingBoxParticle(Supplier<GizmoLineParticle> lineSupplier) {
        this.lines = new Line[]{this.createLine(lineSupplier, 0.5, 0.0, 0.0, Axis.X), this.createLine(lineSupplier, 0.5, 0.0, 1.0, Axis.X), this.createLine(lineSupplier, 0.5, 1.0, 0.0, Axis.X), this.createLine(lineSupplier, 0.5, 1.0, 1.0, Axis.X), this.createLine(lineSupplier, 0.0, 0.5, 0.0, Axis.Y), this.createLine(lineSupplier, 0.0, 0.5, 1.0, Axis.Y), this.createLine(lineSupplier, 1.0, 0.5, 0.0, Axis.Y), this.createLine(lineSupplier, 1.0, 0.5, 1.0, Axis.Y), this.createLine(lineSupplier, 0.0, 0.0, 0.5, Axis.Z), this.createLine(lineSupplier, 1.0, 0.0, 0.5, Axis.Z), this.createLine(lineSupplier, 0.0, 1.0, 0.5, Axis.Z), this.createLine(lineSupplier, 1.0, 1.0, 0.5, Axis.Z)};
    }

    private Line createLine(Supplier<GizmoLineParticle> lineSupplier, double x, double y, double z, Axis axis) {
        return new Line(lineSupplier, axis, new Vector3d(x, y, z));
    }

    @Override
    @NotNull
    public BoundingBox getBoundingBox() {
        return this.box;
    }

    @Override
    public void setBoundingBox(@NotNull BoundingBox box) {
        if (!this.box.equals(box)) {
            this.box = BoundingBox.of(box);
            this.refresh();
        }
    }

    @Override
    public double getLineWidth() {
        return this.lines[0].particle.getWidth();
    }

    @Override
    public void setLineWidth(double lineWidth) {
        for (Line line : this.lines) {
            line.particle.setWidth(lineWidth);
        }
    }

    @Override
    @NotNull
    public ParticleColor getColor() {
        return this.color;
    }

    @Override
    public void setColor(@NotNull ParticleColor color) {
        this.color = color;
        for (Line line : this.lines) {
            line.particle.setColor(color);
        }
    }

    private void refresh() {
        for (Line line : this.lines) {
            line.refresh(this.box);
        }
    }

    @Override
    public void showGizmo() {
        for (Line line : this.lines) {
            line.particle.showGizmo();
        }
    }

    @Override
    public void updateGizmo() {
        for (Line line : this.lines) {
            line.particle.updateGizmo();
        }
    }

    @Override
    public void hideGizmo() {
        for (Line line : this.lines) {
            line.particle.hideGizmo();
        }
    }

    private static class Line {
        private final Axis axis;
        private final Vector3dc offset;
        private final GizmoLineParticle particle;
        private final Vector3d position = new Vector3d();
        private final Vector3d size = new Vector3d();

        private Line(Supplier<GizmoLineParticle> lineSupplier, Axis axis, Vector3dc offset) {
            this.axis = axis;
            this.offset = offset;
            this.particle = lineSupplier.get();
            this.particle.setAxis(axis);
        }

        public void refresh(BoundingBox box) {
            Vector3dc min = box.getMinPosition();
            Vector3dc max = box.getMaxPosition();
            max.sub(min, this.size);
            min.fma(this.offset, (Vector3dc)this.size, this.position);
            this.particle.setCenter(this.position);
            this.particle.setLength(this.axis.getDirection().dot(this.size) + this.particle.getWidth());
        }
    }
}

