/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.message;

import com.google.gson.stream.JsonReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.m56738.easyarmorstands.lib.kyori.adventure.key.Key;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.ComponentLike;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.TextComponent;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.TranslatableComponent;
import me.m56738.easyarmorstands.lib.kyori.adventure.translation.AbstractTranslationStore;
import org.jetbrains.annotations.NotNullByDefault;
import org.jetbrains.annotations.Nullable;

@NotNullByDefault
public class PatternTranslationStore
extends AbstractTranslationStore<String> {
    private static final Pattern ARGUMENT_PATTERN = Pattern.compile("%((\\d+)\\$)?s");

    public PatternTranslationStore(Key name) {
        super(name);
    }

    @Override
    @Nullable
    public MessageFormat translate(String key, Locale locale) {
        return null;
    }

    public void readLocale(Path input, Locale locale) throws IOException {
        this.readLocale(Files.newBufferedReader(input, StandardCharsets.UTF_8), locale);
    }

    public void readLocale(InputStream input, Locale locale) throws IOException {
        this.readLocale(new BufferedReader(new InputStreamReader(input)), locale);
    }

    public void readLocale(Reader reader, Locale locale) throws IOException {
        try (JsonReader jsonReader = new JsonReader(reader);){
            jsonReader.beginObject();
            while (jsonReader.hasNext()) {
                String name = jsonReader.nextName();
                String value = jsonReader.nextString();
                this.register(name, locale, value);
            }
            jsonReader.endObject();
        }
    }

    @Override
    @Nullable
    public Component translate(TranslatableComponent component, Locale locale) {
        String pattern = (String)this.translationValue(component.key(), locale);
        if (pattern == null) {
            return null;
        }
        TextComponent.Builder builder = Component.text();
        Matcher matcher = ARGUMENT_PATTERN.matcher(pattern);
        IndexParser indexParser = new IndexParser();
        int lastEnd = 0;
        while (matcher.find()) {
            int index;
            String before = pattern.substring(lastEnd, matcher.start());
            if (!before.isEmpty()) {
                builder.append((Component)Component.text(before));
            }
            if ((index = indexParser.parseIndex(matcher.group(2))) >= 1 && index <= component.arguments().size()) {
                builder.append((ComponentLike)component.arguments().get(index - 1));
            } else {
                builder.append((Component)Component.text(matcher.group()));
            }
            lastEnd = matcher.end();
        }
        String tail = pattern.substring(lastEnd);
        if (!tail.isEmpty()) {
            builder.append((Component)Component.text(tail));
        }
        return ((TextComponent)((TextComponent.Builder)((TextComponent.Builder)builder.append(component.children())).style(component.style())).build()).compact();
    }

    private static class IndexParser {
        private int counter;

        private IndexParser() {
        }

        public int parseIndex(@Nullable String input) {
            int index = input != null ? Integer.parseInt(input) : ++this.counter;
            return index;
        }
    }
}

