/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.menu.slot;

import me.m56738.easyarmorstands.EasyArmorStandsPlugin;
import me.m56738.easyarmorstands.api.element.Element;
import me.m56738.easyarmorstands.api.element.EntityElement;
import me.m56738.easyarmorstands.api.menu.MenuSlot;
import me.m56738.easyarmorstands.api.menu.MenuSlotContext;
import me.m56738.easyarmorstands.api.menu.MenuSlotFactory;
import me.m56738.easyarmorstands.capability.egg.SpawnEggCapability;
import me.m56738.easyarmorstands.item.SimpleItemTemplate;
import me.m56738.easyarmorstands.menu.slot.EntityCopySlot;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityCopySlotFactory
implements MenuSlotFactory {
    private final SimpleItemTemplate buttonTemplate;
    private final SimpleItemTemplate itemTemplate;
    private final SpawnEggCapability spawnEggCapability;

    public EntityCopySlotFactory(SimpleItemTemplate buttonTemplate, SimpleItemTemplate itemTemplate) {
        this.buttonTemplate = buttonTemplate;
        this.itemTemplate = itemTemplate;
        this.spawnEggCapability = EasyArmorStandsPlugin.getInstance().getCapability(SpawnEggCapability.class);
    }

    @Override
    @Nullable
    public MenuSlot createSlot(@NotNull MenuSlotContext context) {
        if (this.spawnEggCapability == null) {
            return null;
        }
        Element element = context.element();
        if (element instanceof EntityElement) {
            ItemStack item;
            Object entity = ((EntityElement)element).getEntity();
            if (context.permissions().test("easyarmorstands.copy.entity") && (item = this.spawnEggCapability.createSpawnEgg((Entity)entity)) != null) {
                return new EntityCopySlot(this.buttonTemplate.withFallbackTemplate(item), this.itemTemplate.withTemplate(item), element);
            }
        }
        return null;
    }
}

