/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.menu.factory;

import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import me.m56738.easyarmorstands.api.menu.MenuFactory;
import me.m56738.easyarmorstands.api.menu.MenuFactoryBuilder;
import me.m56738.easyarmorstands.api.menu.MenuSlotFactory;
import me.m56738.easyarmorstands.menu.factory.MenuFactoryImpl;
import org.jetbrains.annotations.NotNull;

public class MenuFactoryBuilderImpl
implements MenuFactoryBuilder {
    private final Map<Integer, MenuSlotFactory> slotFactories = new TreeMap<Integer, MenuSlotFactory>();
    private String titleTemplate;
    private int height;
    private MenuSlotFactory background;

    @Override
    public MenuSlotFactory setSlot(int slot, MenuSlotFactory factory) {
        MenuSlotFactory old = this.slotFactories.put(slot, factory);
        this.height = Math.max(this.height, slot / 9 + 1);
        return old;
    }

    @Override
    public void setTitleTemplate(@NotNull String titleTemplate) {
        this.titleTemplate = titleTemplate;
    }

    @Override
    public void setHeight(int height) {
        if (this.height < height) {
            this.height = height;
        }
    }

    @Override
    public void setBackground(MenuSlotFactory background) {
        this.background = background;
    }

    @Override
    @NotNull
    public MenuFactory build() {
        Objects.requireNonNull(this.titleTemplate, "Title not set");
        MenuSlotFactory[] slots = new MenuSlotFactory[this.height * 9];
        for (Map.Entry<Integer, MenuSlotFactory> entry : this.slotFactories.entrySet()) {
            slots[entry.getKey().intValue()] = entry.getValue();
        }
        return new MenuFactoryImpl(this.titleTemplate, slots, this.background);
    }
}

