/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.lib.gizmo.bukkit.viaversion.cube;

import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.entitydata.EntityData;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.m56738.easyarmorstands.lib.gizmo.api.color.GizmoColor;
import me.m56738.easyarmorstands.lib.gizmo.api.cursor.Cursor;
import me.m56738.easyarmorstands.lib.gizmo.api.cursor.Intersection;
import me.m56738.easyarmorstands.lib.gizmo.bukkit.viaversion.cube.GizmoTracker;
import me.m56738.easyarmorstands.lib.gizmo.cube.CubeGizmo;
import me.m56738.easyarmorstands.lib.joml.Quaterniond;
import me.m56738.easyarmorstands.lib.joml.Quaterniondc;
import me.m56738.easyarmorstands.lib.joml.Vector3d;
import me.m56738.easyarmorstands.lib.joml.Vector3dc;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class ViaCubeGizmo
implements CubeGizmo {
    private final GizmoTracker tracker;
    private final List<EntityData> changedData = new ArrayList<EntityData>();
    private final Vector3d position = new Vector3d();
    private final Vector3d offset = new Vector3d();
    private final Quaterniond rotation = new Quaterniond();
    private final Vector3d scale = new Vector3d(DEFAULT_SCALE);
    private GizmoColor color = DEFAULT_COLOR;
    private boolean billboard = false;
    private boolean visible;
    private boolean positionChanged;
    private boolean offsetChanged;
    private boolean rotationChanged;
    private boolean scaleChanged;
    private boolean colorChanged;
    private boolean billboardChanged;

    protected ViaCubeGizmo(UserConnection connection) {
        this.tracker = GizmoTracker.tracker(connection);
    }

    @Override
    @NotNull
    public Vector3dc getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(@NotNull Vector3dc position) {
        if (!Objects.equals(this.position, position)) {
            this.position.set(position);
            this.positionChanged = true;
        }
    }

    @Override
    @NotNull
    public Vector3dc getOffset() {
        return this.offset;
    }

    @Override
    public void setOffset(@NotNull Vector3dc offset) {
        if (!Objects.equals(this.offset, offset)) {
            this.offset.set(offset);
            this.offsetChanged = true;
        }
    }

    @Override
    @NotNull
    public Quaterniondc getRotation() {
        return this.rotation;
    }

    @Override
    public void setRotation(@NotNull Quaterniondc rotation) {
        if (!Objects.equals(this.rotation, rotation)) {
            this.rotation.set(rotation);
            this.rotationChanged = true;
        }
    }

    @Override
    @NotNull
    public Vector3dc getScale() {
        return this.scale;
    }

    @Override
    public void setScale(@NotNull Vector3dc scale) {
        if (!Objects.equals(this.scale, scale)) {
            this.scale.set(scale);
            this.scaleChanged = true;
        }
    }

    @Override
    @NotNull
    public GizmoColor getColor() {
        return this.color;
    }

    @Override
    public void setColor(@NotNull GizmoColor color) {
        if (!Objects.equals(this.color, color)) {
            this.color = color;
            this.colorChanged = true;
        }
    }

    @Override
    public boolean isBillboard() {
        return this.billboard;
    }

    @Override
    public void setBillboard(boolean billboard) {
        if (!Objects.equals(this.billboard, billboard)) {
            this.billboard = billboard;
            this.billboardChanged = true;
        }
    }

    @Override
    @Nullable
    public Intersection intersect(@NotNull Cursor cursor, double threshold) {
        return null;
    }

    @Override
    public void show() {
        if (this.visible) {
            return;
        }
        this.visible = true;
        this.tracker.add(this);
        this.changedData.clear();
        this.addInitialData(this.changedData);
        this.sendAddEntity();
        this.sendData(this.changedData);
    }

    @Override
    public void update() {
        if (!this.visible) {
            return;
        }
        if (this.positionChanged) {
            this.positionChanged = false;
            this.sendPosition();
        }
        this.changedData.clear();
        if (this.offsetChanged) {
            this.offsetChanged = false;
            this.addOffsetData(this.changedData);
        }
        if (this.rotationChanged) {
            this.rotationChanged = false;
            this.addRotationData(this.changedData);
        }
        if (this.colorChanged) {
            this.colorChanged = false;
            this.addColorData(this.changedData);
        }
        if (this.scaleChanged) {
            this.scaleChanged = false;
            this.addScaleData(this.changedData);
        }
        if (this.billboardChanged) {
            this.billboardChanged = false;
            this.addBillboardData(this.changedData);
        }
        if (!this.changedData.isEmpty()) {
            this.addUpdateData(this.changedData);
            this.sendData(this.changedData);
            this.changedData.clear();
        }
    }

    @Override
    public void hide() {
        if (!this.visible) {
            return;
        }
        this.visible = false;
        this.tracker.remove(this);
        this.sendRemoveEntity();
    }

    protected abstract void sendAddEntity();

    protected abstract void sendPosition();

    protected abstract void sendData(List<EntityData> var1);

    protected abstract void sendRemoveEntity();

    protected abstract void addInitialData(List<EntityData> var1);

    protected abstract void addUpdateData(List<EntityData> var1);

    protected abstract void addOffsetData(List<EntityData> var1);

    protected abstract void addRotationData(List<EntityData> var1);

    protected abstract void addScaleData(List<EntityData> var1);

    protected abstract void addColorData(List<EntityData> var1);

    protected abstract void addBillboardData(List<EntityData> var1);

    public void remove() {
        this.visible = false;
    }
}

