/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.lib.gizmo.bukkit.particle.v1_8;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import me.m56738.easyarmorstands.lib.gizmo.api.color.GizmoColor;
import me.m56738.easyarmorstands.lib.gizmo.bukkit.particle.ParticleSpawner;
import me.m56738.easyarmorstands.lib.gizmo.bukkit.particle.ParticleSpawnerFactory;
import me.m56738.easyarmorstands.lib.gizmo.bukkit.util.ReflectionUtil;
import me.m56738.easyarmorstands.lib.joml.Vector3dc;
import org.bukkit.Color;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class ParticleSpawnerFactory_v1_8
implements ParticleSpawnerFactory {
    private final Object particleType;
    private final MethodHandle createPacket;
    private final MethodHandle getHandle;
    private final MethodHandle getConnection;
    private final MethodHandle sendPacket;

    public ParticleSpawnerFactory_v1_8() throws Throwable {
        String cb = ReflectionUtil.cb();
        String nms = ReflectionUtil.nms();
        Class<?> particleTypeClass = Class.forName(nms + ".EnumParticle");
        this.particleType = particleTypeClass.getDeclaredField("REDSTONE").get(null);
        Class<?> particlePacketClass = Class.forName(nms + ".PacketPlayOutWorldParticles");
        this.createPacket = MethodHandles.publicLookup().findConstructor(particlePacketClass, MethodType.methodType(Void.TYPE, particleTypeClass, Boolean.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE, int[].class));
        Class<?> playerClass = Class.forName(cb + ".entity.CraftPlayer");
        Class<?> handleClass = Class.forName(nms + ".EntityPlayer");
        this.getHandle = MethodHandles.publicLookup().findVirtual(playerClass, "getHandle", MethodType.methodType(handleClass));
        Class<?> connectionClass = Class.forName(nms + ".PlayerConnection");
        this.getConnection = MethodHandles.publicLookup().findGetter(handleClass, "playerConnection", connectionClass);
        Class<?> packetClass = Class.forName(nms + ".Packet");
        this.sendPacket = MethodHandles.publicLookup().findVirtual(connectionClass, "sendPacket", MethodType.methodType(Void.TYPE, packetClass));
    }

    public void sendParticle(Object connection, Vector3dc position, GizmoColor color) {
        Color bukkitColor = Color.fromRGB((int)color.asRGB());
        try {
            Object packet = this.createPacket.invoke(this.particleType, true, (float)position.x(), (float)position.y(), (float)position.z(), Math.max((float)bukkitColor.getRed() / 255.0f, Float.MIN_VALUE), (float)bukkitColor.getGreen() / 255.0f, (float)bukkitColor.getBlue() / 255.0f, 1.0f, 0);
            this.sendPacket.invoke(connection, packet);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @NotNull
    public ParticleSpawner createSpawner(@NotNull Player player) {
        try {
            Object handle = this.getHandle.invoke(player);
            Object connection = this.getConnection.invoke(handle);
            return new Spawner(connection);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private class Spawner
    implements ParticleSpawner {
        private final Object connection;

        private Spawner(Object connection) {
            this.connection = connection;
        }

        @Override
        public void spawnParticle(Vector3dc position, GizmoColor color, double size) {
            ParticleSpawnerFactory_v1_8.this.sendParticle(this.connection, position, color);
        }

        @Override
        public double getDensity(double size) {
            return 3.0;
        }
    }
}

