/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.lib.gizmo.bukkit.particle;

import java.util.ArrayList;
import java.util.List;
import me.m56738.easyarmorstands.lib.gizmo.AbstractLineGizmo;
import me.m56738.easyarmorstands.lib.gizmo.api.color.GizmoColor;
import me.m56738.easyarmorstands.lib.gizmo.bukkit.particle.ParticleSpawner;
import me.m56738.easyarmorstands.lib.joml.Math;
import me.m56738.easyarmorstands.lib.joml.Vector3d;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ParticleLineGizmo
extends AbstractLineGizmo {
    private final ParticleSpawner particleSpawner;
    private final List<Vector3d> positions = new ArrayList<Vector3d>();
    private boolean visible;

    public ParticleLineGizmo(ParticleSpawner particleSpawner) {
        this.particleSpawner = particleSpawner;
    }

    @Override
    public void show() {
        this.visible = true;
    }

    @Override
    public void update() {
        if (this.checkAndClearDirty()) {
            this.updatePositions();
        }
        if (this.visible) {
            GizmoColor color = this.getColor();
            double width = this.getWidth();
            for (Vector3d position : this.positions) {
                this.particleSpawner.spawnParticle(position, color, width);
            }
        }
    }

    @Override
    public void hide() {
        this.visible = false;
    }

    private void updatePositions() {
        double length = this.getLength();
        double density = this.particleSpawner.getDensity(this.getWidth());
        int count = Math.clamp(2, 100, (int)Math.round(length * density));
        while (this.positions.size() < count) {
            this.positions.add(new Vector3d());
        }
        while (this.positions.size() > count) {
            this.positions.remove(this.positions.size() - 1);
        }
        Vector3d offset = this.getAxis().direction().mul(length / (double)(count - 1), new Vector3d());
        offset.rotate(this.getRotation());
        Vector3d position = this.getPosition().add(this.getOffset(), new Vector3d());
        for (int i = 0; i < count; ++i) {
            this.positions.get(i).set(position);
            position.add(offset);
        }
    }
}

