/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.lib.gizmo;

import java.util.Objects;
import me.m56738.easyarmorstands.lib.gizmo.AbstractGizmo;
import me.m56738.easyarmorstands.lib.gizmo.api.BoxGizmo;
import me.m56738.easyarmorstands.lib.gizmo.api.cursor.Cursor;
import me.m56738.easyarmorstands.lib.gizmo.api.cursor.Intersection;
import me.m56738.easyarmorstands.lib.joml.Vector3d;
import me.m56738.easyarmorstands.lib.joml.Vector3dc;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class AbstractBoxGizmo
extends AbstractGizmo
implements BoxGizmo {
    private final Vector3d size = new Vector3d(DEFAULT_SIZE);
    private double width = 0.03125;

    @Override
    @NotNull
    public Vector3dc getSize() {
        return this.size;
    }

    @Override
    public void setSize(@NotNull Vector3dc size) {
        if (!Objects.equals(this.size, size)) {
            this.size.set(size);
            this.markDirty();
        }
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(double width) {
        if (!Objects.equals(this.width, width)) {
            this.width = width;
            this.markDirty();
        }
    }

    @Override
    @Nullable
    public Intersection intersect(@NotNull Cursor cursor, double threshold) {
        Vector3d center = this.getPosition().add(this.getOffset(), new Vector3d());
        Vector3d min = center.fma(-0.5, this.getSize(), new Vector3d());
        Vector3d max = center.fma(0.5, this.getSize(), new Vector3d());
        return cursor.intersectBox(min, max, center, this.getRotation());
    }
}

