/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.lib.configurate.serialize;

import java.lang.reflect.AnnotatedType;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import me.m56738.easyarmorstands.lib.configurate.serialize.PatternFlags;
import me.m56738.easyarmorstands.lib.configurate.serialize.ScalarSerializer;
import me.m56738.easyarmorstands.lib.configurate.serialize.SerializationException;
import org.checkerframework.checker.nullness.qual.Nullable;

final class PatternSerializer
extends ScalarSerializer.Annotated<Pattern> {
    PatternSerializer() {
        super(Pattern.class);
    }

    @Override
    public Pattern deserialize(AnnotatedType type, Object obj) throws SerializationException {
        try {
            @Nullable PatternFlags flags = type.getAnnotation(PatternFlags.class);
            if (flags != null) {
                return Pattern.compile(obj.toString(), flags.value());
            }
            return Pattern.compile(obj.toString());
        }
        catch (PatternSyntaxException ex) {
            throw new SerializationException(ex);
        }
    }

    @Override
    public Object serialize(AnnotatedType type, Pattern item, Predicate<Class<?>> typeSupported) {
        return item.pattern();
    }
}

